/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.cli.command;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.spotify.helios.cli.Output;
import com.spotify.helios.cli.Table;
import com.spotify.helios.cli.Utils;
import com.spotify.helios.cli.command.ControlCommand;
import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.Json;
import com.spotify.helios.common.descriptors.DockerVersion;
import com.spotify.helios.common.descriptors.HostInfo;
import com.spotify.helios.common.descriptors.HostStatus;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.descriptors.TaskStatus;
import java.io.BufferedReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.Argument;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;

public class HostListCommand
extends ControlCommand {
    private final Argument quietArg;
    private final Argument patternArg;
    private final Argument fullArg;
    private final Argument labelsArg;

    public HostListCommand(Subparser parser) {
        super(parser);
        parser.help("list hosts");
        this.patternArg = parser.addArgument(new String[]{"pattern"}).nargs("?").setDefault((Object)"").help("Pattern to filter hosts with");
        this.quietArg = parser.addArgument(new String[]{"-q"}).action((ArgumentAction)Arguments.storeTrue()).help("only print host names");
        this.fullArg = parser.addArgument(new String[]{"-f"}).action((ArgumentAction)Arguments.storeTrue()).help("Print full host names.");
        this.labelsArg = parser.addArgument(new String[]{"-l", "--labels"}).action((ArgumentAction)Arguments.append()).setDefault(new ArrayList()).nargs("+").help("Only include hosts that match all of these labels. Labels need to be in the format key=value.");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    int run(Namespace options, HeliosClient client, PrintStream out, boolean json, BufferedReader stdin) throws ExecutionException, InterruptedException {
        Map<String, String> selectedLabels;
        String pattern = options.getString(this.patternArg.getDest());
        ImmutableList hosts = FluentIterable.from((Iterable)((Iterable)client.listHosts().get())).filter(Predicates.containsPattern((String)pattern)).toList();
        boolean full = options.getBoolean(this.fullArg.getDest());
        boolean quiet = options.getBoolean(this.quietArg.getDest());
        if (!Strings.isNullOrEmpty((String)pattern) && hosts.isEmpty()) {
            if (json) {
                out.println(Json.asPrettyStringUnchecked((Object)hosts));
            } else if (!quiet) {
                out.printf("host pattern %s matched no hosts%n", pattern);
            }
            return 1;
        }
        List sortedHosts = Ordering.natural().sortedCopy((Iterable)hosts);
        try {
            selectedLabels = Utils.argToStringMap(options, this.labelsArg);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(e.getMessage() + "\nLabels need to be in the format key=value.");
        }
        if (selectedLabels != null && !selectedLabels.isEmpty() && json) {
            System.err.println("Warning: filtering by label is not supported for JSON output. Not doing any filtering by label.");
        }
        if (quiet) {
            if (json) {
                out.println(Json.asPrettyStringUnchecked((Object)sortedHosts));
            } else {
                for (String host : sortedHosts) {
                    out.println(Output.formatHostname(full, host));
                }
            }
        } else {
            TreeMap statuses = Maps.newTreeMap();
            try {
                Map hostStatuses = (Map)client.hostStatuses((List)hosts).get();
                for (Map.Entry entry : hostStatuses.entrySet()) {
                    statuses.put(entry.getKey(), Futures.immediateFuture(entry.getValue()));
                }
            }
            catch (ExecutionException e) {
                System.err.println("Warning: masters failed batch status fetching.  Falling back to slower host status method");
                for (String string : hosts) {
                    statuses.put(string, client.hostStatus(string));
                }
            }
            if (json) {
                TreeMap sorted = Maps.newTreeMap();
                sorted.putAll(Utils.allAsMap(statuses));
                out.println(Json.asPrettyStringUnchecked((Object)sorted));
            } else {
                Table table = Output.table(out);
                table.row("HOST", "STATUS", "DEPLOYED", "RUNNING", "CPUS", "MEM", "LOAD AVG", "MEM USAGE", "OS", "HELIOS", "DOCKER", "LABELS");
                for (Map.Entry entry : statuses.entrySet()) {
                    void var21_35;
                    String status;
                    String docker;
                    String os;
                    String loadAvg;
                    String mem;
                    String cpus;
                    String host = (String)entry.getKey();
                    HostStatus s = (HostStatus)((ListenableFuture)entry.getValue()).get();
                    if (s == null) continue;
                    boolean skipHost = false;
                    if (selectedLabels != null && !selectedLabels.isEmpty()) {
                        Map hostLabels = s.getLabels();
                        for (Map.Entry entry2 : selectedLabels.entrySet()) {
                            String key = (String)entry2.getKey();
                            String value = (String)entry2.getValue();
                            if (!hostLabels.containsKey(key)) {
                                skipHost = true;
                                break;
                            }
                            String hostValue = (String)hostLabels.get(key);
                            if (!(Strings.isNullOrEmpty((String)value) ? !Strings.isNullOrEmpty((String)hostValue) : !value.equals(hostValue))) continue;
                            skipHost = true;
                            break;
                        }
                    }
                    if (skipHost) continue;
                    HashSet runningDeployedJobs = Sets.newHashSet();
                    for (JobId jobId : s.getJobs().keySet()) {
                        TaskStatus taskStatus = (TaskStatus)s.getStatuses().get(jobId);
                        if (taskStatus == null || taskStatus.getState() != TaskStatus.State.RUNNING) continue;
                        runningDeployedJobs.add(taskStatus);
                    }
                    HostInfo hi = s.getHostInfo();
                    if (hi != null) {
                        long free = hi.getMemoryFreeBytes();
                        long total = hi.getMemoryTotalBytes();
                        String string = String.format("%.2f", Float.valueOf((float)(total - free) / (float)total));
                        cpus = String.valueOf(hi.getCpus());
                        mem = hi.getMemoryTotalBytes() / 0x40000000L + " gb";
                        loadAvg = String.format("%.2f", hi.getLoadAvg());
                        os = hi.getOsName() + " " + hi.getOsVersion();
                        DockerVersion dv = hi.getDockerVersion();
                        docker = dv != null ? String.format("%s (%s)", dv.getVersion(), dv.getApiVersion()) : "";
                    } else {
                        docker = "";
                        os = "";
                        loadAvg = "";
                        mem = "";
                        cpus = "";
                        String string = "";
                    }
                    String version = s.getAgentInfo() != null ? (String)Optional.fromNullable((Object)s.getAgentInfo().getVersion()).or((Object)"") : "";
                    String string = status = s.getStatus() == HostStatus.Status.UP ? "Up" : "Down";
                    if (s.getAgentInfo() != null) {
                        long startTime = s.getAgentInfo().getStartTime();
                        long upTime = s.getAgentInfo().getUptime();
                        status = s.getStatus() == HostStatus.Status.UP ? status + " " + Output.humanDuration(System.currentTimeMillis() - startTime) : status + " " + Output.humanDuration(System.currentTimeMillis() - startTime - upTime);
                    }
                    String labels = Joiner.on((String)", ").withKeyValueSeparator("=").join(s.getLabels());
                    table.row(Output.formatHostname(full, host), status, s.getJobs().size(), runningDeployedJobs.size(), cpus, mem, loadAvg, var21_35, os, version, docker, labels);
                }
                table.print();
            }
        }
        return 0;
    }
}

