/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.cli.command;

import com.spotify.helios.cli.command.ControlCommand;
import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.protocol.RemoveDeploymentGroupResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.concurrent.ExecutionException;
import net.sourceforge.argparse4j.inf.Argument;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;

public class DeploymentGroupRemoveCommand
extends ControlCommand {
    private final Argument nameArg;

    public DeploymentGroupRemoveCommand(Subparser parser) {
        super(parser);
        parser.help("remove a deployment group");
        this.nameArg = parser.addArgument(new String[]{"name"}).required(true).help("Deployment group name");
    }

    @Override
    int run(Namespace options, HeliosClient client, PrintStream out, boolean json, BufferedReader stdin) throws ExecutionException, InterruptedException, IOException {
        String name = options.getString(this.nameArg.getDest());
        if (name == null) {
            throw new IllegalArgumentException("Please specify a name and at least one label.");
        }
        RemoveDeploymentGroupResponse status = (RemoveDeploymentGroupResponse)client.removeDeploymentGroup(name).get();
        if (status == null) {
            throw new RuntimeException("The Helios master could not remove the given deployment group.");
        }
        if (status.getStatus() != RemoveDeploymentGroupResponse.Status.REMOVED) {
            out.println(status.toJsonString());
            return 0;
        }
        if (!json) {
            out.println("Failed: " + status);
        } else {
            out.println(status.toJsonString());
        }
        return 1;
    }
}

