/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.cli.command;

import com.google.common.collect.Maps;
import com.spotify.helios.cli.command.ControlCommand;
import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.Json;
import com.spotify.helios.common.descriptors.DeploymentGroup;
import com.spotify.helios.common.descriptors.HostSelector;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.concurrent.ExecutionException;
import net.sourceforge.argparse4j.inf.Argument;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;

public class DeploymentGroupInspectCommand
extends ControlCommand {
    private final Argument nameArg;

    public DeploymentGroupInspectCommand(Subparser parser) {
        super(parser);
        parser.help("inspect a deployment group");
        this.nameArg = parser.addArgument(new String[]{"name"}).required(true).help("Deployment group name");
    }

    @Override
    int run(Namespace options, HeliosClient client, PrintStream out, boolean json, BufferedReader stdin) throws ExecutionException, InterruptedException, IOException {
        String name = options.getString(this.nameArg.getDest());
        DeploymentGroup deploymentGroup = (DeploymentGroup)client.deploymentGroup(name).get();
        if (deploymentGroup == null) {
            if (json) {
                HashMap output = Maps.newHashMap();
                output.put("status", "DEPLOYMENT_GROUP_NOT_FOUND");
                out.print(Json.asStringUnchecked((Object)output));
            } else {
                out.printf("Unknown deployment group: %s%n", name);
            }
            return 1;
        }
        if (json) {
            out.println(Json.asPrettyStringUnchecked((Object)deploymentGroup));
        } else {
            out.printf("Name: %s%n", deploymentGroup.getName());
            out.printf("Host selectors:%n", new Object[0]);
            for (HostSelector hostSelector : deploymentGroup.getHostSelectors()) {
                out.printf("  %s%n", hostSelector.toPrettyString());
            }
            out.printf("Job: %s%n", deploymentGroup.getJobId());
        }
        return 0;
    }
}

