/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.testing;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.descriptors.Job;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.descriptors.JobStatus;
import com.spotify.helios.testing.DefaultDeployer;
import com.spotify.helios.testing.DefaultProber;
import com.spotify.helios.testing.Deployer;
import com.spotify.helios.testing.HostPickingStrategies;
import com.spotify.helios.testing.HostPickingStrategy;
import com.spotify.helios.testing.JobPrefixFile;
import com.spotify.helios.testing.Jobs;
import com.spotify.helios.testing.Prober;
import com.spotify.helios.testing.TemporaryJob;
import com.spotify.helios.testing.TemporaryJobBuilder;
import com.spotify.helios.testing.TemporaryJobReports;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigList;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.config.ConfigResolveOptions;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueFactory;
import com.typesafe.config.ConfigValueType;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemporaryJobs
implements TestRule {
    private static final Logger log = LoggerFactory.getLogger(TemporaryJobs.class);
    static final String HELIOS_TESTING_PROFILE = "helios.testing.profile";
    private static final String HELIOS_TESTING_PROFILES = "helios.testing.profiles.";
    private static final String DEFAULT_USER = System.getProperty("user.name");
    private static final Prober DEFAULT_PROBER = new DefaultProber();
    private static final String DEFAULT_LOCAL_HOST_FILTER = ".+";
    private static final String DEFAULT_PREFIX_DIRECTORY = "/tmp/helios-temp-jobs";
    private static final String DEFAULT_TEST_REPORT_DIRECTORY = "target/helios-reports/test";
    private static final long JOB_HEALTH_CHECK_INTERVAL_MILLIS = TimeUnit.SECONDS.toMillis(5L);
    private static final long DEFAULT_DEPLOY_TIMEOUT_MILLIS = TimeUnit.MINUTES.toMillis(10L);
    private final HeliosClient client;
    private final Prober prober;
    private final String defaultHostFilter;
    private final JobPrefixFile jobPrefixFile;
    private final Config config;
    private final Map<String, String> env;
    private final List<TemporaryJob> jobs = Lists.newCopyOnWriteArrayList();
    private final Deployer deployer;
    private final TemporaryJobReports reports;
    private final ThreadLocal<TemporaryJobReports.ReportWriter> reportWriter;
    private final ExecutorService executor = MoreExecutors.getExitingExecutorService((ThreadPoolExecutor)((ThreadPoolExecutor)Executors.newFixedThreadPool(1, new ThreadFactoryBuilder().setNameFormat("helios-test-runner-%d").setDaemon(true).build())), (long)0L, (TimeUnit)TimeUnit.SECONDS);

    TemporaryJobs(Builder builder, Config config) {
        this.client = (HeliosClient)Preconditions.checkNotNull((Object)builder.client, (Object)"client");
        this.prober = (Prober)Preconditions.checkNotNull((Object)builder.prober, (Object)"prober");
        this.defaultHostFilter = (String)Preconditions.checkNotNull((Object)builder.hostFilter, (Object)"hostFilter");
        this.env = (Map)Preconditions.checkNotNull((Object)builder.env, (Object)"env");
        Preconditions.checkArgument((builder.deployTimeoutMillis >= 0L ? 1 : 0) != 0, (Object)"deployTimeoutMillis");
        this.deployer = (Deployer)Optional.fromNullable((Object)builder.deployer).or((Object)new DefaultDeployer(this.client, this.jobs, builder.hostPickingStrategy, builder.jobDeployedMessageFormat, builder.deployTimeoutMillis));
        Path prefixDirectory = Paths.get((String)Optional.fromNullable((Object)builder.prefixDirectory).or((Object)DEFAULT_PREFIX_DIRECTORY), new String[0]);
        try {
            this.removeOldJobs(prefixDirectory);
            this.jobPrefixFile = Strings.isNullOrEmpty((String)builder.jobPrefix) ? JobPrefixFile.create(prefixDirectory) : JobPrefixFile.create(builder.jobPrefix, prefixDirectory);
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw Throwables.propagate((Throwable)e);
        }
        Path testReportDirectory = Paths.get((String)Optional.fromNullable((Object)builder.testReportDirectory).or((Object)DEFAULT_TEST_REPORT_DIRECTORY), new String[0]);
        this.reports = new TemporaryJobReports(testReportDirectory);
        this.reportWriter = new ThreadLocal<TemporaryJobReports.ReportWriter>(){

            @Override
            protected TemporaryJobReports.ReportWriter initialValue() {
                log.warn("unable to determine test context, writing event log to stdout");
                return TemporaryJobs.this.reports.getWriterForStream(System.out);
            }
        };
        Config configWithPrefix = ConfigFactory.empty().withValue("prefix", ConfigValueFactory.fromAnyRef((Object)this.prefix()));
        this.config = config.withFallback((ConfigMergeable)configWithPrefix).resolve();
    }

    public void before() {
        this.deployer.readyToDeploy();
    }

    public void after(TemporaryJobReports.ReportWriter writer) {
        TemporaryJobReports.Step undeploy = writer.step("undeploy");
        ArrayList jobIds = Lists.newArrayListWithCapacity((int)this.jobs.size());
        this.executor.shutdownNow();
        try {
            boolean terminated = this.executor.awaitTermination(30L, TimeUnit.SECONDS);
            if (!terminated) {
                log.warn("Failed to stop test runner thread");
            }
        }
        catch (InterruptedException terminated) {
            // empty catch block
        }
        ArrayList errors = Lists.newArrayList();
        for (TemporaryJob job : this.jobs) {
            jobIds.add(job.job().getId());
            job.undeploy(errors);
        }
        undeploy.tag("jobs", jobIds);
        for (AssertionError error : errors) {
            log.error(((Throwable)((Object)error)).getMessage());
        }
        if (errors.isEmpty()) {
            this.jobPrefixFile.delete();
            undeploy.markSuccess();
        }
        undeploy.finish();
    }

    public TemporaryJobBuilder job() {
        TemporaryJobBuilder builder = new TemporaryJobBuilder(this.deployer, this.jobPrefixFile.prefix(), this.prober, this.env, this.reportWriter.get());
        if (this.config.hasPath("env")) {
            Config env = this.config.getConfig("env");
            for (Map.Entry entry : env.entrySet()) {
                builder.env((String)entry.getKey(), ((ConfigValue)entry.getValue()).unwrapped());
            }
        }
        if (this.config.hasPath("version")) {
            builder.version(this.config.getString("version"));
        }
        if (this.config.hasPath("image")) {
            builder.image(this.config.getString("image"));
        }
        if (this.config.hasPath("command")) {
            builder.command(TemporaryJobs.getListByKey("command", this.config));
        }
        if (this.config.hasPath("host")) {
            builder.host(this.config.getString("host"));
        }
        if (this.config.hasPath("deploy")) {
            builder.deploy(TemporaryJobs.getListByKey("deploy", this.config));
        }
        if (this.config.hasPath("imageInfoFile")) {
            builder.imageFromInfoFile(this.config.getString("imageInfoFile"));
        }
        if (this.config.hasPath("registrationDomain")) {
            builder.registrationDomain(this.config.getString("registrationDomain"));
        }
        builder.hostFilter(this.defaultHostFilter);
        return builder;
    }

    private static List<String> getListByKey(String key, Config config) {
        ConfigList endpointList = config.getList(key);
        ArrayList stringList = Lists.newArrayList();
        for (ConfigValue v : endpointList) {
            if (v.valueType() != ConfigValueType.STRING) {
                throw new RuntimeException("Item in " + key + " list [" + v + "] is not a string");
            }
            stringList.add((String)v.unwrapped());
        }
        return stringList;
    }

    public static TemporaryJobs create() {
        return TemporaryJobs.builder().build();
    }

    public static TemporaryJobs create(HeliosClient client) {
        return TemporaryJobs.builder().client(client).build();
    }

    public static TemporaryJobs create(String domain) {
        return TemporaryJobs.builder().domain(domain).build();
    }

    public static TemporaryJobs createFromProfile(String profile) {
        return TemporaryJobs.builder(profile).build();
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                TemporaryJobReports.ReportWriter writer = TemporaryJobs.this.reports.getWriterForTest(description);
                TemporaryJobs.this.reportWriter.set(writer);
                TemporaryJobReports.Step test = writer.step("test");
                TemporaryJobs.this.before();
                try {
                    TemporaryJobs.this.perform(base, writer);
                    test.markSuccess();
                }
                finally {
                    TemporaryJobs.this.after(writer);
                    test.finish();
                    writer.close();
                    TemporaryJobs.this.reportWriter.set(null);
                }
            }
        };
    }

    private void perform(final Statement base, final TemporaryJobReports.ReportWriter writer) throws InterruptedException {
        Future<Object> future = this.executor.submit(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                TemporaryJobs.this.reportWriter.set(writer);
                try {
                    base.evaluate();
                }
                catch (MultipleFailureException e) {
                    List failures = e.getFailures();
                    log.error(String.format("MultipleFailureException contains %d failures:", failures.size()));
                    for (int i = 0; i < failures.size(); ++i) {
                        log.error(String.format("MultipleFailureException %d:", i), (Throwable)failures.get(i));
                    }
                    throw Throwables.propagate((Throwable)e);
                }
                catch (Throwable throwable) {
                    Throwables.propagateIfPossible((Throwable)throwable, Exception.class);
                    throw Throwables.propagate((Throwable)throwable);
                }
                return null;
            }
        });
        while (!future.isDone()) {
            Thread.sleep(JOB_HEALTH_CHECK_INTERVAL_MILLIS);
            this.verifyJobsHealthy();
        }
        try {
            future.get();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause() == null ? e : e.getCause();
            throw Throwables.propagate((Throwable)cause);
        }
    }

    private void verifyJobsHealthy() throws AssertionError {
        for (TemporaryJob job : this.jobs) {
            job.verifyHealthy();
        }
    }

    private void removeOldJobs(Path prefixDirectory) throws ExecutionException, InterruptedException, IOException {
        File[] files = prefixDirectory.toFile().listFiles();
        if (files == null || files.length == 0) {
            return;
        }
        log.info("Removing old temporary jobs");
        Map jobs = (Map)this.client.jobs().get();
        for (File file : files) {
            if (file.getName().endsWith(".tmp") || file.isDirectory()) continue;
            try (JobPrefixFile prefixFile = JobPrefixFile.tryFromExistingFile(file.toPath());){
                if (prefixFile == null) {
                    log.debug("Unable to create JobPrefixFile for {}", (Object)file.getPath());
                    continue;
                }
                boolean jobRemovalFailed = false;
                for (Map.Entry entry : jobs.entrySet()) {
                    JobId jobId = (JobId)entry.getKey();
                    if (!jobId.getName().startsWith(prefixFile.prefix())) continue;
                    JobStatus status = (JobStatus)this.client.jobStatus((JobId)entry.getKey()).get();
                    ImmutableList hosts = ImmutableList.copyOf(status.getDeployments().keySet());
                    List<AssertionError> errors = Jobs.undeploy(this.client, (Job)entry.getValue(), (List<String>)hosts, new ArrayList<AssertionError>());
                    if (errors.isEmpty()) continue;
                    jobRemovalFailed = true;
                }
                if (jobRemovalFailed) continue;
                prefixFile.delete();
            }
            catch (NoSuchFileException e) {
                log.debug("File {} already processed by somebody else.", (Object)file.getPath());
            }
            catch (Exception e) {
                log.warn("Exception processing file {}", (Object)file.getPath(), (Object)e);
            }
        }
    }

    public JobPrefixFile jobPrefixFile() {
        return this.jobPrefixFile;
    }

    public String prefix() {
        return this.jobPrefixFile.prefix();
    }

    public HeliosClient client() {
        return this.client;
    }

    static Config loadConfig() {
        ConfigResolveOptions resolveOptions = ConfigResolveOptions.defaults().setAllowUnresolved(true);
        Config baseConfig = ConfigFactory.load((String)"helios-base.conf", (ConfigParseOptions)ConfigParseOptions.defaults(), (ConfigResolveOptions)resolveOptions);
        log.debug("base config: " + baseConfig);
        Config appConfig = ConfigFactory.load((String)"helios.conf", (ConfigParseOptions)ConfigParseOptions.defaults(), (ConfigResolveOptions)resolveOptions);
        log.debug("app config: " + appConfig);
        Config returnConfig = appConfig.withFallback((ConfigMergeable)baseConfig);
        log.debug("result config: " + returnConfig);
        return returnConfig;
    }

    static String getProfileFromConfig(Config preConfig) {
        if (preConfig.hasPath(HELIOS_TESTING_PROFILE)) {
            return preConfig.getString(HELIOS_TESTING_PROFILE);
        }
        return null;
    }

    public static Builder builder() {
        return TemporaryJobs.builder((String)null);
    }

    public static Builder builder(String profile) {
        return TemporaryJobs.builder(profile, System.getenv());
    }

    static Builder builder(Map<String, String> env) {
        return TemporaryJobs.builder(null, env);
    }

    static Builder builder(String profile, Map<String, String> env) {
        return new Builder(profile, TemporaryJobs.loadConfig(), env);
    }

    static /* synthetic */ String access$1600() {
        return DEFAULT_USER;
    }

    static /* synthetic */ Prober access$1700() {
        return DEFAULT_PROBER;
    }

    static /* synthetic */ long access$1800() {
        return DEFAULT_DEPLOY_TIMEOUT_MILLIS;
    }

    public static class Builder {
        private final Map<String, String> env;
        private final Config config;
        private String user = TemporaryJobs.access$1600();
        private Prober prober = TemporaryJobs.access$1700();
        private Deployer deployer;
        private String hostFilter;
        private HeliosClient client;
        private String prefixDirectory;
        private String testReportDirectory;
        private String jobPrefix;
        private String jobDeployedMessageFormat;
        private HostPickingStrategy hostPickingStrategy = HostPickingStrategies.randomOneHost();
        private long deployTimeoutMillis = TemporaryJobs.access$1800();

        Builder(String profile, Config rootConfig, Map<String, String> env) {
            this.env = env;
            if (profile == null) {
                profile = TemporaryJobs.getProfileFromConfig(rootConfig);
            }
            if (profile == null) {
                this.config = ConfigFactory.empty();
            } else {
                String key = TemporaryJobs.HELIOS_TESTING_PROFILES + profile;
                if (rootConfig.hasPath(key)) {
                    this.config = rootConfig.getConfig(key);
                } else {
                    throw new RuntimeException("The configuration profile " + profile + " does not exist");
                }
            }
            log.info("Using profile: " + profile);
            if (this.config.hasPath("jobDeployedMessageFormat")) {
                this.jobDeployedMessageFormat(this.config.getString("jobDeployedMessageFormat"));
            }
            if (this.config.hasPath("user")) {
                this.user(this.config.getString("user"));
            }
            if (this.config.hasPath("hostFilter")) {
                this.hostFilter(this.config.getString("hostFilter"));
            }
            if (this.config.hasPath("endpoints")) {
                this.endpointStrings(TemporaryJobs.getListByKey("endpoints", this.config));
            }
            if (this.config.hasPath("domain")) {
                this.domain(this.config.getString("domain"));
            }
            if (this.config.hasPath("hostPickingStrategy")) {
                this.processHostPickingStrategy();
            }
            if (this.config.hasPath("deployTimeoutMillis")) {
                this.deployTimeoutMillis(this.config.getLong("deployTimeoutMillis"));
            }
            this.configureWithEnv();
        }

        private void configureWithEnv() {
            String domain;
            String heliosHostFilter = this.env.get("HELIOS_HOST_FILTER");
            if (heliosHostFilter != null) {
                this.hostFilter(heliosHostFilter);
            }
            if (!Strings.isNullOrEmpty((String)(domain = this.env.get("HELIOS_DOMAIN")))) {
                this.domain(domain);
                return;
            }
            String endpoints = this.env.get("HELIOS_ENDPOINTS");
            if (!Strings.isNullOrEmpty((String)endpoints)) {
                this.endpointStrings(Splitter.on((char)',').splitToList((CharSequence)endpoints));
                return;
            }
            if (this.client != null) {
                return;
            }
            String dockerHost = this.env.get("DOCKER_HOST");
            if (dockerHost == null) {
                this.endpoints("http://localhost:5801");
            } else {
                try {
                    URI uri = new URI(dockerHost);
                    this.endpoints("http://" + uri.getHost() + ":5801");
                }
                catch (URISyntaxException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
            if (Strings.isNullOrEmpty((String)this.hostFilter)) {
                this.hostFilter(TemporaryJobs.DEFAULT_LOCAL_HOST_FILTER);
            }
        }

        private void processHostPickingStrategy() {
            String value = this.config.getString("hostPickingStrategy");
            if ("random".equals(value)) {
                this.hostPickingStrategy(HostPickingStrategies.random());
            } else if ("onerandom".equals(value)) {
                this.hostPickingStrategy(HostPickingStrategies.randomOneHost());
            } else if ("deterministic".equals(value)) {
                this.verifyHasStrategyKey(value);
                this.hostPickingStrategy(HostPickingStrategies.deterministic(this.config.getString("hostPickingStrategyKey")));
            } else if ("onedeterministic".equals(value)) {
                this.verifyHasStrategyKey(value);
                this.hostPickingStrategy(HostPickingStrategies.deterministicOneHost(this.config.getString("hostPickingStrategyKey")));
            } else {
                throw new RuntimeException("The hostPickingStrategy " + value + " is not valid. " + "Valid values are [random, onerandom, deterministic, onedeterministic] and the " + "deterministic variants require a string value hostPickingStrategyKey to be set " + "which is used to seed the random number generator, so can be any string.");
            }
        }

        private void verifyHasStrategyKey(String value) {
            if (!this.config.hasPath("hostPickingStrategyKey")) {
                throw new RuntimeException("host picking strategy [" + value + "] selected but no " + "value for hostPickingStrategyKey which is used to seed the random number generator");
            }
        }

        public Builder domain(String domain) {
            return this.client(HeliosClient.newBuilder().setUser(this.user).setDomain(domain).build());
        }

        public Builder endpoints(String ... endpoints) {
            return this.endpointStrings(Arrays.asList(endpoints));
        }

        public Builder endpointStrings(List<String> endpoints) {
            return this.client(HeliosClient.newBuilder().setUser(this.user).setEndpointStrings(endpoints).build());
        }

        public Builder endpoints(URI ... endpoints) {
            return this.endpoints(Arrays.asList(endpoints));
        }

        public Builder endpoints(List<URI> endpoints) {
            return this.client(HeliosClient.newBuilder().setUser(this.user).setEndpoints(endpoints).build());
        }

        public Builder hostPickingStrategy(HostPickingStrategy strategy) {
            this.hostPickingStrategy = strategy;
            return this;
        }

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public Builder jobDeployedMessageFormat(String jobLinkFormat) {
            this.jobDeployedMessageFormat = jobLinkFormat;
            return this;
        }

        public Builder prober(Prober prober) {
            this.prober = prober;
            return this;
        }

        public Builder deployer(Deployer deployer) {
            this.deployer = deployer;
            return this;
        }

        public Builder client(HeliosClient client) {
            this.client = client;
            return this;
        }

        public Builder hostFilter(String hostFilter) {
            this.hostFilter = hostFilter;
            return this;
        }

        public Builder prefixDirectory(String prefixDirectory) {
            this.prefixDirectory = prefixDirectory;
            return this;
        }

        public Builder testReportDirectory(String testReportDirectory) {
            this.testReportDirectory = testReportDirectory;
            return this;
        }

        public Builder jobPrefix(String jobPrefix) {
            this.jobPrefix = jobPrefix;
            return this;
        }

        public Builder deployTimeoutMillis(long timeout) {
            this.deployTimeoutMillis = timeout;
            return this;
        }

        public TemporaryJobs build() {
            return new TemporaryJobs(this, this.config);
        }
    }
}

