/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.testing;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.ThreadLocalRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JobPrefixFile
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(JobPrefixFile.class);
    private final String prefix;
    private final Path file;
    private FileChannel channel;
    private FileLock lock;

    public static JobPrefixFile create(Path directory) throws IOException {
        return JobPrefixFile.create(null, directory);
    }

    public static JobPrefixFile create(String prefix, Path directory) throws IOException {
        return new JobPrefixFile(prefix, directory);
    }

    public static JobPrefixFile tryFromExistingFile(Path file) throws IOException {
        FileLock lock;
        Preconditions.checkNotNull((Object)file);
        FileChannel channel = FileChannel.open(file, StandardOpenOption.WRITE);
        try {
            lock = channel.tryLock();
        }
        catch (OverlappingFileLockException e) {
            JobPrefixFile.close(channel);
            return null;
        }
        catch (Exception e) {
            JobPrefixFile.close(channel);
            throw e;
        }
        if (lock == null) {
            JobPrefixFile.close(channel);
            return null;
        }
        return new JobPrefixFile(file, channel, lock);
    }

    private JobPrefixFile(String prefix, Path directory) throws IOException {
        Preconditions.checkNotNull((Object)directory);
        this.prefix = prefix == null ? "tmp-" + new SimpleDateFormat("yyyyMMdd").format(new Date()) + "-" + Integer.toHexString(ThreadLocalRandom.current().nextInt()) : prefix;
        Files.createDirectories(directory, new FileAttribute[0]);
        this.file = directory.resolve(this.prefix);
        Path tmp = directory.resolve(this.prefix + ".tmp");
        try {
            this.channel = FileChannel.open(tmp, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
            this.lock = this.channel.lock();
            Files.move(tmp, this.file, new CopyOption[0]);
        }
        catch (Exception e) {
            this.deleteIfExists(tmp);
            this.deleteIfExists(this.file);
            JobPrefixFile.close(this.channel);
            throw new RuntimeException("Failed to create job prefix file " + this.file, e);
        }
    }

    private JobPrefixFile(Path file, FileChannel channel, FileLock lock) throws IOException, IllegalStateException {
        this.file = (Path)Preconditions.checkNotNull((Object)file, (Object)"file");
        this.channel = (FileChannel)Preconditions.checkNotNull((Object)channel, (Object)"channel");
        this.lock = (FileLock)Preconditions.checkNotNull((Object)lock, (Object)"lock");
        this.prefix = file.getFileName().toString();
    }

    public void delete() {
        this.release();
        this.deleteIfExists(this.file);
    }

    private void deleteIfExists(Path file) {
        if (file != null) {
            try {
                Files.deleteIfExists(file);
            }
            catch (Exception e) {
                log.warn("Failed to delete file {}", (Object)file, (Object)e);
            }
        }
    }

    public String prefix() {
        return this.prefix;
    }

    public void release() {
        JobPrefixFile.close(this.lock);
        this.lock = null;
        JobPrefixFile.close(this.channel);
        this.channel = null;
    }

    @Override
    public void close() {
        this.release();
    }

    private static void close(AutoCloseable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception e) {
                log.debug("Failed to close {}", (Object)closeable.getClass().getSimpleName(), (Object)e);
            }
        }
    }
}

