/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.testing;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import com.spotify.helios.common.Json;
import com.spotify.helios.common.descriptors.HealthCheck;
import com.spotify.helios.common.descriptors.HttpHealthCheck;
import com.spotify.helios.common.descriptors.Job;
import com.spotify.helios.common.descriptors.PortMapping;
import com.spotify.helios.common.descriptors.ServiceEndpoint;
import com.spotify.helios.common.descriptors.ServicePorts;
import com.spotify.helios.common.descriptors.TcpHealthCheck;
import com.spotify.helios.testing.Deployer;
import com.spotify.helios.testing.Prober;
import com.spotify.helios.testing.TemporaryJob;
import com.spotify.helios.testing.TemporaryJobReports;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Pattern;
import org.joda.time.DateTime;
import org.junit.Assert;

public class TemporaryJobBuilder {
    private static final Pattern JOB_NAME_FORBIDDEN_CHARS = Pattern.compile("[^0-9a-zA-Z-_.]+");
    private static final int DEFAULT_EXPIRES_MINUTES = 30;
    private final List<String> hosts = Lists.newArrayList();
    private final Job.Builder builder = Job.newBuilder();
    private final Set<String> waitPorts = Sets.newHashSet();
    private final Deployer deployer;
    private final String jobNamePrefix;
    private final Map<String, String> env;
    private final TemporaryJobReports.ReportWriter reportWriter;
    private String hostFilter;
    private Prober prober;
    private TemporaryJob job;

    public TemporaryJobBuilder(Deployer deployer, String jobNamePrefix, Prober defaultProber, Map<String, String> env, TemporaryJobReports.ReportWriter reportWriter) {
        Preconditions.checkNotNull((Object)deployer, (Object)"deployer");
        Preconditions.checkNotNull((Object)jobNamePrefix, (Object)"jobNamePrefix");
        Preconditions.checkNotNull((Object)defaultProber, (Object)"defaultProber");
        this.deployer = deployer;
        this.jobNamePrefix = jobNamePrefix;
        this.prober = defaultProber;
        this.builder.setRegistrationDomain(jobNamePrefix);
        this.env = env;
        this.reportWriter = reportWriter;
    }

    public TemporaryJobBuilder version(String jobVersion) {
        this.builder.setVersion(jobVersion);
        return this;
    }

    public TemporaryJobBuilder image(String image) {
        this.builder.setImage(image);
        return this;
    }

    public TemporaryJobBuilder registrationDomain(String domain) {
        this.builder.setRegistrationDomain(domain);
        return this;
    }

    public TemporaryJobBuilder command(List<String> command) {
        this.builder.setCommand(command);
        return this;
    }

    public TemporaryJobBuilder command(String ... command) {
        return this.command(Arrays.asList(command));
    }

    public TemporaryJobBuilder env(String key, Object value) {
        this.builder.addEnv(key, value.toString());
        return this;
    }

    public TemporaryJobBuilder disablePrivateRegistrationDomain() {
        this.builder.setRegistrationDomain("");
        return this;
    }

    public TemporaryJobBuilder port(String name, int internalPort) {
        return this.port(name, internalPort, true);
    }

    public TemporaryJobBuilder port(String name, int internalPort, boolean wait) {
        return this.port(name, internalPort, null, wait);
    }

    public TemporaryJobBuilder port(String name, int internalPort, Integer externalPort) {
        return this.port(name, internalPort, externalPort, true);
    }

    public TemporaryJobBuilder port(String name, int internalPort, Integer externalPort, boolean wait) {
        return this.port(name, internalPort, externalPort, wait, "tcp");
    }

    public TemporaryJobBuilder port(String name, int internalPort, String protocol) {
        return this.port(name, internalPort, true, protocol);
    }

    private TemporaryJobBuilder port(String name, int internalPort, boolean wait, String protocol) {
        return this.port(name, internalPort, null, wait, protocol);
    }

    public TemporaryJobBuilder port(String name, int internalPort, Integer externalPort, String protocol) {
        return this.port(name, internalPort, externalPort, true, protocol);
    }

    private TemporaryJobBuilder port(String name, int internalPort, Integer externalPort, boolean wait, String protocol) {
        this.builder.addPort(name, PortMapping.of((int)internalPort, (Integer)externalPort, (String)protocol));
        if (wait) {
            this.waitPorts.add(name);
        }
        return this;
    }

    public TemporaryJobBuilder registration(ServiceEndpoint endpoint, ServicePorts ports) {
        this.builder.addRegistration(endpoint, ports);
        return this;
    }

    public TemporaryJobBuilder registration(String service, String protocol, String ... ports) {
        return this.registration(ServiceEndpoint.of((String)service, (String)protocol), ServicePorts.of((String[])ports));
    }

    public TemporaryJobBuilder registration(Map<ServiceEndpoint, ServicePorts> registration) {
        this.builder.setRegistration(registration);
        return this;
    }

    public TemporaryJobBuilder volume(String path, String source) {
        this.builder.addVolume(path, source);
        return this;
    }

    public TemporaryJobBuilder host(String host) {
        this.hosts.add(host);
        return this;
    }

    public TemporaryJobBuilder hostFilter(String hostFilter) {
        this.hostFilter = hostFilter;
        return this;
    }

    public TemporaryJobBuilder expires(Date expires) {
        this.builder.setExpires(expires);
        return this;
    }

    public TemporaryJobBuilder prober(Prober prober) {
        this.prober = prober;
        return this;
    }

    public TemporaryJobBuilder healthCheck(HealthCheck healthCheck) {
        this.builder.setHealthCheck(healthCheck);
        return this;
    }

    public TemporaryJobBuilder httpHealthCheck(String port, String path) {
        this.builder.setHealthCheck((HealthCheck)HttpHealthCheck.of((String)port, (String)path));
        return this;
    }

    public TemporaryJobBuilder tcpHealthCheck(String port) {
        this.builder.setHealthCheck((HealthCheck)TcpHealthCheck.of((String)port));
        return this;
    }

    public TemporaryJob deploy(String ... hosts) {
        return this.deploy(Arrays.asList(hosts));
    }

    public TemporaryJob deploy(List<String> hosts) {
        this.hosts.addAll(hosts);
        if (this.job == null) {
            if (this.builder.getName() == null && this.builder.getVersion() == null) {
                this.builder.setName(this.jobName(this.builder.getImage(), this.jobNamePrefix));
                this.builder.setVersion(this.randomVersion());
            }
            if (this.builder.getExpires() == null) {
                this.builder.setExpires(new DateTime().plusMinutes(30).toDate());
            }
            if (this.builder.getHealthCheck() != null) {
                this.waitPorts.clear();
            }
            if (this.hosts.isEmpty()) {
                if (Strings.isNullOrEmpty((String)this.hostFilter)) {
                    this.hostFilter = this.env.get("HELIOS_HOST_FILTER");
                }
                this.job = this.deployer.deploy(this.builder.build(), this.hostFilter, this.waitPorts, this.prober, this.reportWriter);
            } else {
                this.job = this.deployer.deploy(this.builder.build(), this.hosts, this.waitPorts, this.prober, this.reportWriter);
            }
        }
        return this.job;
    }

    public TemporaryJobBuilder imageFromBuild() {
        URL info;
        block5: {
            String envPath = this.env.get("IMAGE_INFO_PATH");
            if (envPath != null) {
                return this.imageFromInfoFile(envPath);
            }
            String name = (String)Optional.fromNullable((Object)this.env.get("IMAGE_INFO_NAME")).or((Object)"image_info.json");
            try {
                info = Resources.getResource((String)name);
            }
            catch (IllegalArgumentException e) {
                info = this.getFromFileSystem(name);
                if (info != null) break block5;
                throw new IllegalArgumentException(e.getMessage() + " Try building the docker image first with `mvn docker:build` " + "which will generate image_info.json.");
            }
        }
        try {
            String json = Resources.asCharSource((URL)info, (Charset)Charsets.UTF_8).read();
            return this.imageFromInfoJson(json, info.toString());
        }
        catch (IOException e) {
            throw new AssertionError("Failed to load image info", e);
        }
    }

    private URL getFromFileSystem(String name) {
        File file = new File("target/" + name);
        if (!file.exists()) {
            return null;
        }
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("TEST");
        }
    }

    public TemporaryJobBuilder imageFromInfoFile(Path path) {
        return this.imageFromInfoFile(path.toFile());
    }

    public TemporaryJobBuilder imageFromInfoFile(String path) {
        return this.imageFromInfoFile(new File(path));
    }

    public TemporaryJobBuilder imageFromInfoFile(File file) {
        String json;
        try {
            json = Files.toString((File)file, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            throw new AssertionError((Object)("Failed to read image info file: " + file + ": " + e.getMessage()));
        }
        return this.imageFromInfoJson(json, file.toString());
    }

    private TemporaryJobBuilder imageFromInfoJson(String json, String source) {
        try {
            JsonNode info = Json.readTree((String)json);
            JsonNode imageNode = info.get("image");
            if (imageNode == null) {
                Assert.fail((String)("Missing image field in image info: " + source));
            }
            if (imageNode.getNodeType() != JsonNodeType.STRING) {
                Assert.fail((String)("Bad image field in image info: " + source));
            }
            String image = imageNode.asText();
            return this.image(image);
        }
        catch (IOException e) {
            throw new AssertionError("Failed to parse image info: " + source, e);
        }
    }

    private String jobName(String s, String jobNamePrefix) {
        return jobNamePrefix + "_" + JOB_NAME_FORBIDDEN_CHARS.matcher(s).replaceAll("_");
    }

    private String randomVersion() {
        return Integer.toHexString(ThreadLocalRandom.current().nextInt());
    }
}

