/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.testing;

import com.google.common.base.Throwables;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class Polling {
    Polling() {
    }

    public static <T> T await(long timeout, TimeUnit timeUnit, Callable<T> callable) throws Exception {
        long deadline = System.nanoTime() + timeUnit.toNanos(timeout);
        while (System.nanoTime() < deadline) {
            T value = callable.call();
            if (value != null) {
                return value;
            }
            Thread.sleep(500L);
        }
        throw new TimeoutException();
    }

    public static <T> T awaitUnchecked(long timeout, TimeUnit timeUnit, Callable<T> callable) throws TimeoutException {
        try {
            return Polling.await(timeout, timeUnit, callable);
        }
        catch (Throwable e) {
            Throwables.propagateIfInstanceOf((Throwable)e, TimeoutException.class);
            throw Throwables.propagate((Throwable)e);
        }
    }
}

