/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.testing;

import com.google.common.util.concurrent.ListenableFuture;
import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.descriptors.Job;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.protocol.JobDeleteResponse;
import com.spotify.helios.common.protocol.JobUndeployResponse;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Jobs {
    private static final Logger log = LoggerFactory.getLogger(Jobs.class);
    static final long TIMEOUT_MILLIS = TimeUnit.MINUTES.toMillis(5L);

    Jobs() {
    }

    static <T> T get(ListenableFuture<T> future) throws InterruptedException, ExecutionException, TimeoutException {
        return Jobs.get(future, TIMEOUT_MILLIS);
    }

    static <T> T get(ListenableFuture<T> future, long timeout) throws InterruptedException, ExecutionException, TimeoutException {
        return (T)future.get(timeout, TimeUnit.MILLISECONDS);
    }

    static String getJobDescription(Job job) {
        String shortHash = job.getId().getHash().substring(0, 7);
        return String.format("%s (Job %s)", job.getImage(), shortHash);
    }

    static List<AssertionError> undeploy(HeliosClient client, Job job, List<String> hosts, List<AssertionError> errors) {
        JobId id = job.getId();
        for (String host : hosts) {
            log.info("Undeploying {} from {}", (Object)Jobs.getJobDescription(job), (Object)host);
            try {
                JobUndeployResponse response = (JobUndeployResponse)Jobs.get(client.undeploy(id, host));
                if (response.getStatus() == JobUndeployResponse.Status.OK || response.getStatus() == JobUndeployResponse.Status.JOB_NOT_FOUND) continue;
                errors.add(new AssertionError((Object)String.format("Failed to undeploy job %s - %s", id, response)));
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                errors.add(new AssertionError((Object)e));
            }
        }
        try {
            log.debug("Deleting job {}", (Object)id);
            JobDeleteResponse response = (JobDeleteResponse)Jobs.get(client.deleteJob(id));
            if (response.getStatus() != JobDeleteResponse.Status.OK && response.getStatus() != JobDeleteResponse.Status.JOB_NOT_FOUND) {
                errors.add(new AssertionError((Object)String.format("Failed to delete job %s - %s", id.toString(), response.toString())));
            }
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            errors.add(new AssertionError((Object)e));
        }
        return errors;
    }
}

