/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios;

import com.google.common.base.Throwables;
import com.google.common.io.Files;
import com.spotify.helios.Polling;
import com.spotify.helios.TemporaryPorts;
import com.spotify.helios.ZooKeeperTestManager;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.io.FileUtils;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.test.TestingServer;
import org.apache.zookeeper.KeeperException;

public class ZooKeeperTestingServerManager
implements ZooKeeperTestManager {
    public final TemporaryPorts temporaryPorts = TemporaryPorts.create();
    private final int port = this.temporaryPorts.localPort("zookeeper");
    private final String endpoint = "127.0.0.1:" + this.port;
    private final File dataDir = Files.createTempDir();
    private CuratorFramework curator;
    private TestingServer server;

    public ZooKeeperTestingServerManager() {
        this(null);
    }

    public ZooKeeperTestingServerManager(String namespace) {
        ExponentialBackoffRetry retryPolicy = new ExponentialBackoffRetry(1000, 3);
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder().connectString(this.endpoint).retryPolicy((RetryPolicy)retryPolicy);
        if (namespace != null) {
            builder = builder.namespace(namespace);
        }
        this.curator = builder.build();
        this.curator.start();
        this.start();
    }

    @Override
    public void ensure(String path) throws Exception {
        this.curator.newNamespaceAwareEnsurePath(path).ensure(this.curator.getZookeeperClient());
    }

    @Override
    public void close() throws InterruptedException {
        try {
            this.server.close();
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
        }
        this.stop();
        FileUtils.deleteQuietly((File)this.dataDir);
    }

    @Override
    public String connectString() {
        return this.endpoint;
    }

    @Override
    public CuratorFramework curator() {
        return this.curator;
    }

    @Override
    public void awaitUp(long timeout, TimeUnit timeunit) throws TimeoutException {
        Polling.awaitUnchecked(timeout, timeunit, new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try {
                    return ZooKeeperTestingServerManager.this.curator().usingNamespace(null).getChildren().forPath("/");
                }
                catch (Exception e) {
                    return null;
                }
            }
        });
    }

    @Override
    public void awaitDown(int timeout, TimeUnit timeunit) throws TimeoutException {
        Polling.awaitUnchecked(timeout, timeunit, new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try {
                    ZooKeeperTestingServerManager.this.curator().usingNamespace(null).getChildren().forPath("/");
                    return null;
                }
                catch (KeeperException.ConnectionLossException e) {
                    return true;
                }
                catch (Exception e) {
                    return null;
                }
            }
        });
    }

    @Override
    public void start() {
        try {
            this.server = new TestingServer(this.port, this.dataDir);
            this.awaitUp(2L, TimeUnit.MINUTES);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void stop() throws InterruptedException {
        try {
            this.server.stop();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void backup(Path destination) {
        try {
            FileUtils.copyDirectory((File)this.dataDir, (File)destination.toFile());
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void restore(Path source) {
        try {
            FileUtils.deleteDirectory((File)this.dataDir);
            FileUtils.copyDirectory((File)source.toFile(), (File)this.dataDir);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void reset() {
        FileUtils.deleteQuietly((File)this.dataDir);
    }
}

