/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.spotify.helios.Polling;
import com.spotify.helios.TemporaryPorts;
import com.spotify.helios.ZooKeeperTestManager;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.test.InstanceSpec;
import org.apache.curator.test.TestingCluster;
import org.apache.curator.test.TestingZooKeeperServer;
import org.apache.zookeeper.KeeperException;
import org.junit.Rule;

public class ZooKeeperTestingClusterManager
implements ZooKeeperTestManager {
    @Rule
    public final TemporaryPorts temporaryPorts = TemporaryPorts.create();
    private final Path tempDir;
    private List<InstanceSpec> zkPeers;
    private List<InetSocketAddress> zkAddresses;
    private List<TestingZooKeeperServer> zkServers;
    private List<CuratorFramework> peerCurators;
    private CuratorFramework curator;
    private TestingCluster cluster;

    public ZooKeeperTestingClusterManager() {
        try {
            this.tempDir = Files.createTempDirectory("helios-zk", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        this.start();
    }

    @Override
    public void ensure(String path) throws Exception {
        this.curator.newNamespaceAwareEnsurePath(path).ensure(this.curator.getZookeeperClient());
    }

    @Override
    public void close() {
        try {
            for (CuratorFramework curator : this.peerCurators) {
                curator.close();
            }
            this.curator.close();
            this.stop();
            FileUtils.deleteDirectory((File)this.tempDir.toFile());
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public String connectString() {
        return this.connectString(this.zkAddresses);
    }

    @Override
    public CuratorFramework curator() {
        return this.curator;
    }

    @Override
    public void awaitUp(long timeout, TimeUnit timeunit) throws TimeoutException {
        Polling.awaitUnchecked(timeout, timeunit, new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try {
                    return ZooKeeperTestingClusterManager.this.curator().getChildren().forPath("/");
                }
                catch (Exception e) {
                    return null;
                }
            }
        });
    }

    @Override
    public void awaitDown(int timeout, TimeUnit timeunit) throws TimeoutException {
        Polling.awaitUnchecked(timeout, timeunit, new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try {
                    ZooKeeperTestingClusterManager.this.curator().getChildren().forPath("/");
                    return null;
                }
                catch (KeeperException.ConnectionLossException e) {
                    return true;
                }
                catch (Exception e) {
                    return null;
                }
            }
        });
    }

    @Override
    public void start() {
        try {
            this.start0();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        this.curator = this.createCurator(this.connectString(this.zkAddresses));
        try {
            this.awaitUp(2L, TimeUnit.MINUTES);
        }
        catch (TimeoutException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void stop() {
        try {
            this.cluster.stop();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private void start0() {
        this.zkPeers = this.createPeers(3);
        this.zkAddresses = this.allocateAddresses(this.zkPeers);
        this.peerCurators = this.createCurators(this.zkAddresses);
        System.setProperty("zookeeper.jmx.log4j.disable", "true");
        this.cluster = new TestingCluster(this.zkPeers);
        this.zkServers = this.cluster.getServers();
        try {
            this.cluster.start();
        }
        catch (Exception e) {
            this.stop();
            throw Throwables.propagate((Throwable)e);
        }
    }

    private List<CuratorFramework> createCurators(List<InetSocketAddress> addresses) {
        ImmutableList.Builder curators = ImmutableList.builder();
        for (InetSocketAddress address : addresses) {
            curators.add((Object)this.createCurator(this.connectString(address)));
        }
        return curators.build();
    }

    private CuratorFramework createCurator(String connectString) {
        ExponentialBackoffRetry retryPolicy = new ExponentialBackoffRetry(1000, 3);
        CuratorFramework curator = CuratorFrameworkFactory.newClient((String)connectString, (RetryPolicy)retryPolicy);
        curator.start();
        return curator;
    }

    public void startPeer(int id) {
        if (this.zkServers.get(id).getQuorumPeer().isRunning()) {
            throw new IllegalStateException("peer is already running: " + id);
        }
        try {
            this.zkServers.get(id).restart();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void stopPeer(int id) {
        try {
            this.zkServers.get(id).stop();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void resetPeer(int id) {
        if (this.zkServers.get(id).getQuorumPeer().isRunning()) {
            throw new IllegalStateException("peer is still running: " + id);
        }
        Path peerDir = this.peerDir(id);
        try {
            FileUtils.deleteDirectory((File)peerDir.toFile());
            Files.createDirectory(peerDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public CuratorFramework peerCurator(int id) {
        return this.peerCurators.get(id);
    }

    private String connectString(InetSocketAddress ... addresses) {
        return this.connectString(Arrays.asList(addresses));
    }

    private String connectString(Iterable<InetSocketAddress> addresses) {
        return Joiner.on((char)',').join(this.endpoints(addresses));
    }

    private Path peerDir(int id) {
        return this.tempDir.resolve(Long.toString(id));
    }

    private List<InstanceSpec> createPeers(int n) {
        ImmutableList.Builder peers = ImmutableList.builder();
        for (int i = 0; i < n; ++i) {
            int port = this.temporaryPorts.localPort("zk-client" + i);
            int electionPort = this.temporaryPorts.localPort("zk-elect" + i);
            int quorumPort = this.temporaryPorts.localPort("zk-quorum" + i);
            Path peerDir = this.peerDir(i);
            try {
                Files.createDirectory(peerDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
            InstanceSpec spec = new InstanceSpec(peerDir.toFile(), port, electionPort, quorumPort, true, i);
            peers.add((Object)spec);
        }
        return peers.build();
    }

    private List<String> endpoints(Iterable<InetSocketAddress> addresses) {
        return ImmutableList.copyOf((Iterable)Iterables.transform(addresses, (Function)new Function<InetSocketAddress, String>(){

            public String apply(InetSocketAddress addr) {
                return addr.getHostString() + ":" + addr.getPort();
            }
        }));
    }

    private List<InetSocketAddress> allocateAddresses(List<InstanceSpec> peers) {
        return ImmutableList.copyOf((Iterable)Iterables.transform(peers, (Function)new Function<InstanceSpec, InetSocketAddress>(){

            public InetSocketAddress apply(@Nullable InstanceSpec spec) {
                return new InetSocketAddress("127.0.0.1", spec.getPort());
            }
        }));
    }
}

