/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.serviceregistration;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ServiceRegistration {
    private final List<Endpoint> endpoints;

    public ServiceRegistration(List<Endpoint> endpoints) {
        this.endpoints = Collections.unmodifiableList(new ArrayList<Endpoint>(endpoints));
    }

    public List<Endpoint> getEndpoints() {
        return this.endpoints;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class EndpointHealthCheck {
        public static final String HTTP = "http";
        public static final String TCP = "tcp";
        private final String type;
        private final String path;

        public EndpointHealthCheck(String type, String path) {
            this.type = type;
            this.path = path;
        }

        public String getType() {
            return this.type;
        }

        public String getPath() {
            return this.path;
        }

        public static EndpointHealthCheck newHttpCheck(String path) {
            return new EndpointHealthCheck(HTTP, path);
        }

        public static EndpointHealthCheck newTcpCheck() {
            return new EndpointHealthCheck(TCP, null);
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("type", (Object)this.type).add("path", (Object)this.path).toString();
        }
    }

    public static class Endpoint {
        private final String name;
        private final String protocol;
        private final int port;
        private final String domain;
        private final String host;
        private final List<String> tags;
        private final EndpointHealthCheck healthCheck;

        public Endpoint(String name, String protocol, int port, String domain, String host, List<String> tags, EndpointHealthCheck healthCheck) {
            this.name = name;
            this.protocol = protocol;
            this.port = port;
            this.domain = domain;
            this.host = host;
            this.tags = tags;
            this.healthCheck = healthCheck;
        }

        public String getHost() {
            return this.host;
        }

        public String getDomain() {
            return this.domain;
        }

        public String getName() {
            return this.name;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public int getPort() {
            return this.port;
        }

        public List<String> getTags() {
            return this.tags;
        }

        public EndpointHealthCheck getHealthCheck() {
            return this.healthCheck;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("name", (Object)this.name).add("protocol", (Object)this.protocol).add("port", this.port).add("domain", (Object)this.domain).add("host", (Object)this.host).add("tags", this.tags).add("healthCheck", (Object)this.healthCheck).toString();
        }
    }

    public static class Builder {
        private List<Endpoint> endpoints = new ArrayList<Endpoint>();

        @Deprecated
        public Builder endpoint(String name, String protocol, int port) {
            this.endpoints.add(new Endpoint(name, protocol, port, "", "", null, null));
            return this;
        }

        public Builder endpoint(String name, String protocol, int port, String domain, String host) {
            this.endpoints.add(new Endpoint(name, protocol, port, domain, host, null, null));
            return this;
        }

        public Builder endpoint(String name, String protocol, int port, String domain, String host, List<String> tags) {
            this.endpoints.add(new Endpoint(name, protocol, port, domain, host, tags, null));
            return this;
        }

        public Builder endpoint(String name, String protocol, int port, String domain, String host, List<String> tags, EndpointHealthCheck healthCheck) {
            this.endpoints.add(new Endpoint(name, protocol, port, domain, host, tags, healthCheck));
            return this;
        }

        public ServiceRegistration build() {
            return new ServiceRegistration(this.endpoints);
        }
    }
}

