/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.serviceregistration;

import com.spotify.helios.serviceregistration.ServiceRegistrarFactory;
import com.spotify.helios.serviceregistration.ServiceRegistrarLoadingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.slf4j.Logger;

public class ServiceRegistrarLoader {
    private static final List<Package> PROVIDED = Arrays.asList(Logger.class.getPackage(), ServiceRegistrarLoader.class.getPackage());
    private static final ClassLoader CURRENT = ServiceRegistrarLoader.class.getClassLoader();

    public static ServiceRegistrarFactory load() throws ServiceRegistrarLoadingException {
        return ServiceRegistrarLoader.load("classpath", CURRENT);
    }

    public static ServiceRegistrarFactory load(Path plugin) throws ServiceRegistrarLoadingException {
        return ServiceRegistrarLoader.load(plugin, CURRENT, ServiceRegistrarLoader.extensionClassLoader(CURRENT));
    }

    public static ServiceRegistrarFactory load(Path plugin, ClassLoader environment, ClassLoader parent) throws ServiceRegistrarLoadingException {
        return ServiceRegistrarLoader.load("plugin jar file: " + plugin, ServiceRegistrarLoader.pluginClassLoader(plugin, environment, parent));
    }

    public static ServiceRegistrarFactory load(String source, ClassLoader classLoader) throws ServiceRegistrarLoadingException {
        ServiceLoader<ServiceRegistrarFactory> loader;
        try {
            loader = ServiceLoader.load(ServiceRegistrarFactory.class, classLoader);
        }
        catch (ServiceConfigurationError e) {
            throw new ServiceRegistrarLoadingException("Failed to load service registrar from " + source, e);
        }
        Iterator<ServiceRegistrarFactory> iterator = loader.iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    private static ClassLoader extensionClassLoader(ClassLoader environment) {
        ClassLoader prev = null;
        for (ClassLoader cl = environment; cl != null; cl = cl.getParent()) {
            prev = cl;
        }
        return prev;
    }

    private static ClassLoader pluginClassLoader(Path plugin, ClassLoader environment, ClassLoader parent) {
        URL url;
        try {
            url = plugin.toFile().toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Failed to load plugin jar " + plugin, e);
        }
        FilteringClassLoader providedClassLoader = new FilteringClassLoader(PROVIDED, environment, parent);
        return new URLClassLoader(new URL[]{url}, (ClassLoader)providedClassLoader);
    }

    private static class FilteringClassLoader
    extends ClassLoader {
        private final List<Package> packages;
        private final ClassLoader environment;

        public FilteringClassLoader(List<Package> packages, ClassLoader environment, ClassLoader parent) {
            super(parent);
            this.packages = packages;
            this.environment = environment;
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            for (Package pkg : this.packages) {
                if (!name.startsWith(pkg.getName())) continue;
                return this.environment.loadClass(name);
            }
            return super.findClass(name);
        }
    }
}

