/*
 * Decompiled with CFR 0.152.
 */
package at.meks.validation.result;

import at.meks.validation.result.ErrorDescription;
import at.meks.validation.result.ValidationException;

public class ValidationResult {
    private static final ValidationResult OK_RESULT = new ValidationResult(true, null);
    private final boolean valid;
    private final ErrorDescription errorDescription;

    private ValidationResult(boolean valid, ErrorDescription errorDescription) {
        this.valid = valid;
        this.errorDescription = errorDescription;
    }

    public String getErrorCode() {
        return this.errorDescription.getErrorCode();
    }

    public String getErrorMessage() {
        return this.errorDescription.getErrorMessage();
    }

    public boolean isValid() {
        return this.valid;
    }

    public static ValidationResult ok() {
        return OK_RESULT;
    }

    public static ValidationResult fail(ErrorDescription onErrorMessage) {
        return new ValidationResult(false, onErrorMessage);
    }

    public void throwIfInvalid(String myTestedParam) throws ValidationException {
        if (!this.isValid()) {
            throw new ValidationException(myTestedParam, this.errorDescription);
        }
    }
}

