/*
 * Decompiled with CFR 0.152.
 */
package at.meks.validation;

import at.meks.validation.ValidationConfiguration;
import java.text.MessageFormat;
import java.time.DayOfWeek;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Locale;
import java.util.ResourceBundle;

public class ErrorMessageResolver {
    private ResourceBundle bundle;

    public ErrorMessageResolver() {
        this.initializeBundle();
    }

    private void initializeBundle() {
        this.bundle = ResourceBundle.getBundle("at/meks/validation/errors", ValidationConfiguration.getLocale(), new ResourceBundle.Control(){

            @Override
            public Locale getFallbackLocale(String baseName, Locale locale) {
                return Locale.ROOT;
            }
        });
    }

    public String getLengthIsMoreThanMessage(int size) {
        return MessageFormat.format(this.getBundleString("lengthIsMoreThan"), size);
    }

    private String getBundleString(String lengthIsMoreThan) {
        if (!this.bundle.getLocale().equals(ValidationConfiguration.getLocale())) {
            this.initializeBundle();
        }
        return this.bundle.getString(lengthIsMoreThan);
    }

    public String getLengthIsLessThanMessage(int size) {
        return MessageFormat.format(this.getBundleString("lengthIsLessThan"), size);
    }

    public String getHasLengthMessage(int length) {
        return MessageFormat.format(this.getBundleString("hasLength"), length);
    }

    public String getContainsMessage(String contained) {
        return MessageFormat.format(this.getBundleString("contains"), contained);
    }

    public String getIsNotBlankMessage() {
        return this.getBundleString("isNotBlank");
    }

    public String getIsInListMessage(Collection<String> validValueSupplier) {
        return MessageFormat.format(this.getBundleString("isInList"), String.join((CharSequence)", ", validValueSupplier));
    }

    public String getIsDateMessage(DateTimeFormatter formatter) {
        return MessageFormat.format(this.getBundleString("isDate"), formatter);
    }

    public String getIsNumericMessage() {
        return this.getBundleString("isNumeric");
    }

    public String getContainsNotOnlyMessage(String containedValue) {
        return MessageFormat.format(this.getBundleString("containsNotOnly"), containedValue);
    }

    public String getNotNullMessage() {
        return this.getBundleString("mustNotBeNull");
    }

    public String getListContainsOnlyMessage(Object containedValue) {
        return MessageFormat.format(this.getBundleString("list.containsOnly"), containedValue);
    }

    public String getListContainsMessage(Object containedValue) {
        return MessageFormat.format(this.getBundleString("list.contains"), containedValue);
    }

    public String getListDoesNotContainMessage(Object excludedValue) {
        return MessageFormat.format(this.getBundleString("list.doesNotContain"), excludedValue);
    }

    public String getListIsNotEmptyMessage() {
        return this.getBundleString("list.isNotEmpty");
    }

    public String getListIsEmptyMessage() {
        return this.getBundleString("list.isEmpty");
    }

    public String getListHasSizeMessage(int size) {
        return MessageFormat.format(this.getBundleString("list.hasSize"), size);
    }

    public String getListHasMinSizeMessage(int size) {
        return MessageFormat.format(this.getBundleString("list.hasMinSize"), size);
    }

    public String getListHasMaxSizeMessage(int size) {
        return MessageFormat.format(this.getBundleString("list.hasMaxSize"), size);
    }

    public String getIsLessThanMessage(Object compareTo) {
        return MessageFormat.format(this.getBundleString("isLessThan"), compareTo);
    }

    public String getIsGreaterThanMessage(Object compareTo) {
        return MessageFormat.format(this.getBundleString("isGreaterThan"), compareTo);
    }

    public String getIsBetweenMessage(Object min, Object max) {
        return MessageFormat.format(this.getBundleString("isBetween"), min, max);
    }

    public String getIsIntMessage() {
        return this.getBundleString("isInt");
    }

    public String getIsByteMessage() {
        return this.getBundleString("isByte");
    }

    public String getIsShortMessage() {
        return this.getBundleString("isShort");
    }

    public String getIsEqualToMessage(Object comparedTo) {
        return MessageFormat.format(this.getBundleString("isEqualTo"), comparedTo);
    }

    public String getIsNotEqualToMessage(Object compareTo) {
        return MessageFormat.format(this.getBundleString("isNotEqualTo"), compareTo);
    }

    public String getIsNullMessage() {
        return this.getBundleString("isNull");
    }

    public String getIsDateFirstDayOfYearMessage() {
        return this.getBundleString("date.isDateFirstDayOfYear");
    }

    public String getIsDateFirstDayOfMonthMessage() {
        return this.getBundleString("date.isDateFirstDayOfMonth");
    }

    public String getIsTimeStartOfDayMessage() {
        return this.getBundleString("date.isTimeStartOfDay");
    }

    public String getIsLastDayOfMonthMessage() {
        return this.getBundleString("date.isLastDayOfMonth");
    }

    public String getIsDateLastDayOfYearMessage() {
        return this.getBundleString("date.isDateLastDayOfYear");
    }

    public String getIsDateTimeStartOfHourMessage() {
        return this.getBundleString("date.isDateTimeStartOfHour");
    }

    public String getIsDateDayOfWeekMessage(DayOfWeek dayOfWeek) {
        return MessageFormat.format(this.getBundleString("isDateDayOfWeek"), dayOfWeek);
    }
}

