/*
 * Decompiled with CFR 0.152.
 */
package at.meks.validation.validations.list;

import at.meks.validation.ErrorMessageResolver;
import at.meks.validation.Validation;
import at.meks.validation.result.ErrorDescriptionBuilder;
import at.meks.validation.validations.list.CoreListValidations;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class ListValidationsWithErrorCode {
    private static final ErrorMessageResolver MESSAGE_RESOLVER = new ErrorMessageResolver();
    private static final CoreListValidations VALIDATIONS = new CoreListValidations();

    private ListValidationsWithErrorCode() {
    }

    public static <T> Validation<List<T>> containsOnly(T containedValue, String errorCode) {
        return ListValidationsWithErrorCode.containsOnly(() -> containedValue, errorCode);
    }

    public static <T> Validation<List<T>> containsOnly(Supplier<T> containedValue, String errorCode) {
        return VALIDATIONS.containsOnly(containedValue, () -> ErrorDescriptionBuilder.withCode(MESSAGE_RESOLVER.getListContainsOnlyMessage(containedValue.get()), errorCode));
    }

    public static <T> Validation<List<T>> contains(T containedValue, String errorCode) {
        return ListValidationsWithErrorCode.contains(() -> containedValue, errorCode);
    }

    public static <T> Validation<List<T>> contains(Supplier<T> containedValue, String errorCode) {
        return VALIDATIONS.contains(containedValue, () -> ErrorDescriptionBuilder.withCode(MESSAGE_RESOLVER.getListContainsMessage(containedValue.get()), errorCode));
    }

    public static <T> Validation<List<T>> doesNotContain(T excludedValue, String errorCode) {
        return ListValidationsWithErrorCode.doesNotContain(() -> excludedValue, errorCode);
    }

    public static <T> Validation<List<T>> doesNotContain(Supplier<T> excludedValue, String errorCode) {
        return VALIDATIONS.doesNotContain(excludedValue, () -> ErrorDescriptionBuilder.withCode(MESSAGE_RESOLVER.getListDoesNotContainMessage(excludedValue.get()), errorCode));
    }

    public static <T> Validation<List<T>> isNotEmpty(String errorCode) {
        return VALIDATIONS.isNotEmpty(ErrorDescriptionBuilder.withCode(MESSAGE_RESOLVER.getListIsNotEmptyMessage(), errorCode));
    }

    public static <T> Validation<List<T>> isEmpty(String errorCode) {
        return VALIDATIONS.isEmpty(ErrorDescriptionBuilder.withCode(MESSAGE_RESOLVER.getListIsEmptyMessage(), errorCode));
    }

    public static <T> Validation<List<T>> hasSize(int size, String errorCode) {
        return ListValidationsWithErrorCode.hasSize(() -> size, errorCode);
    }

    public static <T> Validation<List<T>> hasSize(Supplier<Integer> size, String errorCode) {
        return VALIDATIONS.hasSize(size, () -> ErrorDescriptionBuilder.withCode(MESSAGE_RESOLVER.getListHasSizeMessage((Integer)size.get()), errorCode));
    }

    public static <T> Validation<List<T>> hasMinSize(int size, String errorCode) {
        return ListValidationsWithErrorCode.hasMinSize(() -> size, errorCode);
    }

    public static <T> Validation<List<T>> hasMinSize(Supplier<Integer> size, String errorCode) {
        return VALIDATIONS.hasMinSize(size, () -> ErrorDescriptionBuilder.withCode(MESSAGE_RESOLVER.getListHasMinSizeMessage((Integer)size.get()), errorCode));
    }

    public static <T> Validation<List<T>> hasMaxSize(int size, String errorCode) {
        return ListValidationsWithErrorCode.hasMaxSize(() -> size, errorCode);
    }

    public static <T> Validation<List<T>> hasMaxSize(Supplier<Integer> size, String errorCode) {
        return VALIDATIONS.hasMaxSize(size, () -> ErrorDescriptionBuilder.withCode(MESSAGE_RESOLVER.getListHasMaxSizeMessage((Integer)size.get()), errorCode));
    }

    public static <T, E> Validation<List<T>> onProperty(Function<T, E> function, Validation<List<E>> validation) {
        return VALIDATIONS.onProperty(function, validation);
    }

    public static <T> Validation<List<T>> forType(Class<T> listType, Validation<List<T>> validation) {
        return VALIDATIONS.forType(listType, validation);
    }
}

