/*
 * Decompiled with CFR 0.152.
 */
package at.meks.validation.validations.common;

import at.meks.validation.ErrorMessageResolver;
import at.meks.validation.Validation;
import at.meks.validation.result.ErrorDescriptionBuilder;
import at.meks.validation.validations.common.CoreCommonValidations;
import java.util.function.Supplier;

public class CommonValidations {
    private static final ErrorMessageResolver MESSAGE_RESOLVER = new ErrorMessageResolver();
    private static final CoreCommonValidations VALIDATIONS = new CoreCommonValidations();

    private CommonValidations() {
    }

    public static <T> Validation<T> notNull() {
        return VALIDATIONS.notNull(ErrorDescriptionBuilder.withMessage(MESSAGE_RESOLVER.getNotNullMessage()));
    }

    public static <T> Validation<T> isEqualTo(T compareTo) {
        return CommonValidations.isEqualTo(() -> compareTo);
    }

    public static <T> Validation<T> isEqualTo(Supplier<T> compareTo) {
        return VALIDATIONS.isEqualTo(compareTo, () -> ErrorDescriptionBuilder.withMessage(MESSAGE_RESOLVER.getIsEqualToMessage(compareTo.get())));
    }

    public static <T> Validation<T> isNotEqualTo(T compareTo) {
        return CommonValidations.isNotEqualTo(() -> compareTo);
    }

    public static <T> Validation<T> isNotEqualTo(Supplier<T> compareTo) {
        return VALIDATIONS.isNotEqualTo(compareTo, () -> ErrorDescriptionBuilder.withMessage(MESSAGE_RESOLVER.getIsNotEqualToMessage(compareTo.get())));
    }

    public static <T, C extends Comparable<T>> Validation<C> isLessThan(T compareTo) {
        return CommonValidations.isLessThan(() -> compareTo);
    }

    public static <T, C extends Comparable<T>> Validation<C> isLessThan(Supplier<T> compareTo) {
        return VALIDATIONS.isLessThan(compareTo, () -> ErrorDescriptionBuilder.withMessage(MESSAGE_RESOLVER.getIsLessThanMessage(compareTo.get())));
    }

    public static <T, C extends Comparable<T>> Validation<C> isGreaterThan(T compareTo) {
        return CommonValidations.isGreaterThan(() -> compareTo);
    }

    public static <T, C extends Comparable<T>> Validation<C> isGreaterThan(Supplier<T> compareTo) {
        return VALIDATIONS.isGreaterThan(compareTo, () -> ErrorDescriptionBuilder.withMessage(MESSAGE_RESOLVER.getIsGreaterThanMessage(compareTo.get())));
    }

    public static <T, C extends Comparable<T>> Validation<C> isBetween(T min, T max) {
        return CommonValidations.isBetween(() -> min, () -> max);
    }

    public static <T, C extends Comparable<T>> Validation<C> isBetween(Supplier<T> min, Supplier<T> max) {
        return VALIDATIONS.isBetween(min, max, () -> ErrorDescriptionBuilder.withMessage(MESSAGE_RESOLVER.getIsBetweenMessage(min.get(), max.get())));
    }
}

