/*
 * Decompiled with CFR 0.152.
 */
package at.meks.validation.validations.number;

import at.meks.validation.ErrorMessageResolver;
import at.meks.validation.Validation;
import at.meks.validation.result.ErrorDescriptionBuilder;
import at.meks.validation.validations.number.CoreNumberValidations;
import java.util.function.Supplier;

public class NumberValidationsWithErrorCode {
    private static ErrorMessageResolver messageResolver = new ErrorMessageResolver();
    private static CoreNumberValidations validations = new CoreNumberValidations();

    private NumberValidationsWithErrorCode() {
    }

    public static <T extends Number> Validation<T> isLessThan(T compareTo, String errorCode) {
        return NumberValidationsWithErrorCode.isLessThan(() -> compareTo, errorCode);
    }

    public static <T extends Number> Validation<T> isLessThan(Supplier<T> compareTo, String errorCode) {
        return validations.isLessThan(compareTo, () -> ErrorDescriptionBuilder.withCode(messageResolver.getIsNumberLessThanMessage((Number)compareTo.get()), errorCode));
    }

    public static <T extends Number> Validation<T> isGreaterThan(T compareTo, String errorCode) {
        return NumberValidationsWithErrorCode.isGreaterThan(() -> compareTo, errorCode);
    }

    public static <T extends Number> Validation<T> isGreaterThan(Supplier<T> compareTo, String errorCode) {
        return validations.isGreaterThan(compareTo, () -> ErrorDescriptionBuilder.withCode(messageResolver.getIsNumberGreaterThanMessage((Number)compareTo.get()), errorCode));
    }

    public static <T extends Number> Validation<T> isBetween(T min, T max, String errorCode) {
        return NumberValidationsWithErrorCode.isBetween(() -> min, () -> max, errorCode);
    }

    public static <T extends Number> Validation<T> isBetween(Supplier<T> min, Supplier<T> max, String errorCode) {
        return validations.isBetween(min, max, () -> ErrorDescriptionBuilder.withCode(messageResolver.getNumberIsBetweenMessage((Number)min.get(), (Number)max.get()), errorCode));
    }

    public static <T extends Number> Validation<T> isInt(String errorCode) {
        return validations.isInt(ErrorDescriptionBuilder.withCode(messageResolver.getIsIntMessage(), errorCode));
    }

    public static <T extends Number> Validation<T> isByte(String errorCode) {
        return validations.isByte(ErrorDescriptionBuilder.withCode(messageResolver.getIsByteMessage(), errorCode));
    }

    public static <T extends Number> Validation<T> isShort(String errorCode) {
        return validations.isShort(ErrorDescriptionBuilder.withCode(messageResolver.getIsShortMessage(), errorCode));
    }
}

