/*
 * Decompiled with CFR 0.152.
 */
package at.meks.validation.validations.number;

import at.meks.validation.ErrorMessageResolver;
import at.meks.validation.Validation;
import at.meks.validation.result.ErrorDescriptionBuilder;
import at.meks.validation.validations.number.CoreNumberValidations;
import java.util.function.Supplier;

public class NumberValidations {
    private static ErrorMessageResolver messageResolver = new ErrorMessageResolver();
    private static CoreNumberValidations validations = new CoreNumberValidations();

    private NumberValidations() {
    }

    public static <T extends Number> Validation<T> isLessThan(T compareTo) {
        return NumberValidations.isLessThan(() -> compareTo);
    }

    public static <T extends Number> Validation<T> isLessThan(Supplier<T> compareTo) {
        return validations.isLessThan(compareTo, () -> ErrorDescriptionBuilder.withMessage(messageResolver.getIsNumberLessThanMessage((Number)compareTo.get())));
    }

    public static <T extends Number> Validation<T> isGreaterThan(T compareTo) {
        return NumberValidations.isGreaterThan(() -> compareTo);
    }

    public static <T extends Number> Validation<T> isGreaterThan(Supplier<T> compareTo) {
        return validations.isGreaterThan(compareTo, () -> ErrorDescriptionBuilder.withMessage(messageResolver.getIsNumberGreaterThanMessage((Number)compareTo.get())));
    }

    public static <T extends Number> Validation<T> isBetween(T min, T max) {
        return NumberValidations.isBetween(() -> min, () -> max);
    }

    public static <T extends Number> Validation<T> isBetween(Supplier<T> min, Supplier<T> max) {
        return validations.isBetween(min, max, () -> ErrorDescriptionBuilder.withMessage(messageResolver.getNumberIsBetweenMessage((Number)min.get(), (Number)max.get())));
    }

    public static <T extends Number> Validation<T> isInt() {
        return validations.isInt(ErrorDescriptionBuilder.withMessage(messageResolver.getIsIntMessage()));
    }

    public static <T extends Number> Validation<T> isByte() {
        return validations.isByte(ErrorDescriptionBuilder.withMessage(messageResolver.getIsByteMessage()));
    }

    public static <T extends Number> Validation<T> isShort() {
        return validations.isShort(ErrorDescriptionBuilder.withMessage(messageResolver.getIsShortMessage()));
    }
}

