/*
 * Decompiled with CFR 0.152.
 */
package at.meks.validation.validations.common;

import at.meks.validation.ErrorMessageResolver;
import at.meks.validation.Validation;
import at.meks.validation.result.ErrorDescriptionBuilder;
import at.meks.validation.validations.common.CoreCommonValidations;
import java.util.function.Supplier;

public class CommonValidations {
    private static ErrorMessageResolver messageResolver = new ErrorMessageResolver();
    private static CoreCommonValidations validations = new CoreCommonValidations();

    private CommonValidations() {
    }

    public static <T> Validation<T> notNull() {
        return validations.notNull(ErrorDescriptionBuilder.withMessage(messageResolver.getNotNullMessage()));
    }

    public static <T> Validation<T> isEqualTo(T compareTo) {
        return CommonValidations.isEqualTo(() -> compareTo);
    }

    public static <T> Validation<T> isEqualTo(Supplier<T> compareTo) {
        return validations.isEqualTo(compareTo, () -> ErrorDescriptionBuilder.withMessage(messageResolver.getIsEqualToMessage(compareTo.get())));
    }

    public static <T> Validation<T> isNotEqualTo(T compareTo) {
        return CommonValidations.isNotEqualTo(() -> compareTo);
    }

    public static <T> Validation<T> isNotEqualTo(Supplier<T> compareTo) {
        return validations.isNotEqualTo(compareTo, () -> ErrorDescriptionBuilder.withMessage(messageResolver.getIsNotEqualToMessage(compareTo.get())));
    }
}

