/*
 * Decompiled with CFR 0.152.
 */
package at.meks.validation.validations.list;

import at.meks.validation.ErrorMessageResolver;
import at.meks.validation.Validation;
import at.meks.validation.result.ErrorDescriptionBuilder;
import at.meks.validation.validations.list.CoreListValidations;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class ListValidationsWithErrorCode {
    private static ErrorMessageResolver messageResolver = new ErrorMessageResolver();
    private static CoreListValidations validations = new CoreListValidations();

    private ListValidationsWithErrorCode() {
    }

    public static <T> Validation<List<T>> containsOnly(T containedValue, String errorCode) {
        return ListValidationsWithErrorCode.containsOnly(() -> containedValue, errorCode);
    }

    public static <T> Validation<List<T>> containsOnly(Supplier<T> containedValue, String errorCode) {
        return validations.containsOnly(containedValue, () -> ErrorDescriptionBuilder.withCode(messageResolver.getListContainsOnlyMessage(containedValue.get()), errorCode));
    }

    public static <T> Validation<List<T>> contains(T containedValue, String errorCode) {
        return ListValidationsWithErrorCode.contains(() -> containedValue, errorCode);
    }

    public static <T> Validation<List<T>> contains(Supplier<T> containedValue, String errorCode) {
        return validations.contains(containedValue, () -> ErrorDescriptionBuilder.withCode(messageResolver.getListContainsMessage(containedValue.get()), errorCode));
    }

    public static <T> Validation<List<T>> doesNotContain(T excludedValue, String errorCode) {
        return ListValidationsWithErrorCode.doesNotContain(() -> excludedValue, errorCode);
    }

    public static <T> Validation<List<T>> doesNotContain(Supplier<T> excludedValue, String errorCode) {
        return validations.doesNotContain(excludedValue, () -> ErrorDescriptionBuilder.withCode(messageResolver.getListDoesNotContainMessage(excludedValue.get()), errorCode));
    }

    public static <T> Validation<List<T>> isNotEmpty(String errorCode) {
        return validations.isNotEmpty(ErrorDescriptionBuilder.withCode(messageResolver.getListIsNotEmptyMessage(), errorCode));
    }

    public static <T> Validation<List<T>> isEmpty(String errorCode) {
        return validations.isEmpty(ErrorDescriptionBuilder.withCode(messageResolver.getListIsEmptyMessage(), errorCode));
    }

    public static <T> Validation<List<T>> hasSize(int size, String errorCode) {
        return ListValidationsWithErrorCode.hasSize(() -> size, errorCode);
    }

    public static <T> Validation<List<T>> hasSize(Supplier<Integer> size, String errorCode) {
        return validations.hasSize(size, () -> ErrorDescriptionBuilder.withCode(messageResolver.getListHasSizeMessage((Integer)size.get()), errorCode));
    }

    public static <T> Validation<List<T>> hasMinSize(int size, String errorCode) {
        return ListValidationsWithErrorCode.hasMinSize(() -> size, errorCode);
    }

    public static <T> Validation<List<T>> hasMinSize(Supplier<Integer> size, String errorCode) {
        return validations.hasMinSize(size, () -> ErrorDescriptionBuilder.withCode(messageResolver.getListHasMinSizeMessage((Integer)size.get()), errorCode));
    }

    public static <T> Validation<List<T>> hasMaxSize(int size, String errorCode) {
        return ListValidationsWithErrorCode.hasMaxSize(() -> size, errorCode);
    }

    public static <T> Validation<List<T>> hasMaxSize(Supplier<Integer> size, String errorCode) {
        return validations.hasMaxSize(size, () -> ErrorDescriptionBuilder.withCode(messageResolver.getListHasMaxSizeMessage((Integer)size.get()), errorCode));
    }

    public static <T, E> Validation<List<T>> onProperty(Function<T, E> function, Validation<List<E>> validation) {
        return validations.onProperty(function, validation);
    }

    public static <T> Validation<List<T>> forType(Class<T> listType, Validation<List<T>> validation) {
        return validations.forType(listType, validation);
    }
}

