/*
 * Decompiled with CFR 0.152.
 */
package at.meks.validation.validations.list;

import at.meks.validation.ErrorMessageResolver;
import at.meks.validation.Validation;
import at.meks.validation.result.ErrorDescriptionBuilder;
import at.meks.validation.validations.list.CoreListValidations;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class ListValidations {
    private static ErrorMessageResolver messageResolver = new ErrorMessageResolver();
    private static CoreListValidations validations = new CoreListValidations();

    private ListValidations() {
    }

    public static <T> Validation<List<T>> containsOnly(T containedValue) {
        return ListValidations.containsOnly(() -> containedValue);
    }

    public static <T> Validation<List<T>> containsOnly(Supplier<T> containedValue) {
        return validations.containsOnly(containedValue, () -> ErrorDescriptionBuilder.withMessage(messageResolver.getListContainsOnlyMessage(containedValue.get())));
    }

    public static <T> Validation<List<T>> contains(T containedValue) {
        return ListValidations.contains(() -> containedValue);
    }

    public static <T> Validation<List<T>> contains(Supplier<T> containedValue) {
        return validations.contains(containedValue, () -> ErrorDescriptionBuilder.withMessage(messageResolver.getListContainsMessage(containedValue.get())));
    }

    public static <T> Validation<List<T>> doesNotContain(T excludedValue) {
        return ListValidations.doesNotContain(() -> excludedValue);
    }

    public static <T> Validation<List<T>> doesNotContain(Supplier<T> excludedValue) {
        return validations.doesNotContain(excludedValue, () -> ErrorDescriptionBuilder.withMessage(messageResolver.getListDoesNotContainMessage(excludedValue.get())));
    }

    public static <T> Validation<List<T>> isNotEmpty() {
        return validations.isNotEmpty(ErrorDescriptionBuilder.withMessage(messageResolver.getListIsNotEmptyMessage()));
    }

    public static <T> Validation<List<T>> isEmpty() {
        return validations.isEmpty(ErrorDescriptionBuilder.withMessage(messageResolver.getListIsEmptyMessage()));
    }

    public static <T> Validation<List<T>> hasSize(int size) {
        return ListValidations.hasSize(() -> size);
    }

    public static <T> Validation<List<T>> hasSize(Supplier<Integer> size) {
        return validations.hasSize(size, () -> ErrorDescriptionBuilder.withMessage(messageResolver.getListHasSizeMessage((Integer)size.get())));
    }

    public static <T> Validation<List<T>> hasMinSize(int size) {
        return ListValidations.hasMinSize(() -> size);
    }

    public static <T> Validation<List<T>> hasMinSize(Supplier<Integer> size) {
        return validations.hasMinSize(size, () -> ErrorDescriptionBuilder.withMessage(messageResolver.getListHasMinSizeMessage((Integer)size.get())));
    }

    public static <T> Validation<List<T>> hasMaxSize(int size) {
        return ListValidations.hasMaxSize(() -> size);
    }

    public static <T> Validation<List<T>> hasMaxSize(Supplier<Integer> size) {
        return validations.hasMaxSize(size, () -> ErrorDescriptionBuilder.withMessage(messageResolver.getListHasMaxSizeMessage((Integer)size.get())));
    }

    public static <T, E> Validation<List<T>> onProperty(Function<T, E> function, Validation<List<E>> validation) {
        return validations.onProperty(function, validation);
    }

    public static <T> Validation<List<T>> forType(Class<T> listType, Validation<List<T>> validation) {
        return validations.forType(listType, validation);
    }
}

