/*
 * Decompiled with CFR 0.152.
 */
package at.meks.validation.validations.common;

import at.meks.validation.ErrorMessageResolver;
import at.meks.validation.Validation;
import at.meks.validation.result.ErrorDescriptionBuilder;
import at.meks.validation.validations.common.CoreCommonValidations;
import java.util.function.Supplier;

public class CommonValidationsWithErrorCode {
    private static ErrorMessageResolver messageResolver = new ErrorMessageResolver();
    private static CoreCommonValidations validations = new CoreCommonValidations();

    private CommonValidationsWithErrorCode() {
    }

    public static <T> Validation<T> notNull(String errorCode) {
        return validations.notNull(ErrorDescriptionBuilder.withCode(messageResolver.getNotNullMessage(), errorCode));
    }

    public static <T> Validation<T> isEqualTo(T compareTo, String errorCode) {
        return CommonValidationsWithErrorCode.isEqualTo(() -> compareTo, errorCode);
    }

    public static <T> Validation<T> isEqualTo(Supplier<T> compareTo, String errorCode) {
        return validations.isEqualTo(compareTo, () -> ErrorDescriptionBuilder.withCode(messageResolver.getIsEqualToMessage(compareTo.get()), errorCode));
    }
}

