/*
 * Decompiled with CFR 0.152.
 */
package at.meks.validation.validations.number;

import at.meks.validation.ErrorMessageResolver;
import at.meks.validation.Validation;
import at.meks.validation.result.ErrorDescriptionBuilder;
import at.meks.validation.validations.number.CoreNumberValidations;

public class NumberValidationsWithErrorCode {
    private static ErrorMessageResolver messageResolver = new ErrorMessageResolver();
    private static CoreNumberValidations validations = new CoreNumberValidations();

    private NumberValidationsWithErrorCode() {
    }

    public static <T extends Number> Validation<T> isLessThan(T compareTo, String errorCode) {
        return validations.isLessThan(compareTo, ErrorDescriptionBuilder.withCode(messageResolver.getIsNumberLessThanMessage(compareTo), errorCode));
    }

    public static <T extends Number> Validation<T> isGreaterThan(T compareTo, String errorCode) {
        return validations.isGreaterThan(compareTo, ErrorDescriptionBuilder.withCode(messageResolver.getIsNumberGreaterThanMessage(compareTo), errorCode));
    }

    public static <T extends Number> Validation<T> isBetween(T min, T max, String errorCode) {
        return validations.isBetween(min, max, ErrorDescriptionBuilder.withCode(messageResolver.getNumberIsBetweenMessage(min, max), errorCode));
    }

    public static <T extends Number> Validation<T> isInt(String errorCode) {
        return validations.isInt(ErrorDescriptionBuilder.withCode(messageResolver.getIsIntMessage(), errorCode));
    }

    public static <T extends Number> Validation<T> isByte(String errorCode) {
        return validations.isByte(ErrorDescriptionBuilder.withCode(messageResolver.getIsByteMessage(), errorCode));
    }

    public static <T extends Number> Validation<T> isShort(String errorCode) {
        return validations.isShort(ErrorDescriptionBuilder.withCode(messageResolver.getIsShortMessage(), errorCode));
    }
}

