/*
 * Decompiled with CFR 0.152.
 */
package at.meks.validation.validations.number;

import at.meks.validation.SimpleValidation;
import at.meks.validation.Validation;
import at.meks.validation.result.ErrorDescription;
import org.apache.commons.lang3.Range;

public class CoreNumberValidations {
    public <T extends Number> Validation<T> isLessThan(T compareTo, ErrorDescription errorDescription) {
        return SimpleValidation.from(number -> number.doubleValue() < compareTo.doubleValue(), () -> errorDescription);
    }

    public <T extends Number> Validation<T> isGreaterThan(T compareTo, ErrorDescription errorDescription) {
        return SimpleValidation.from(number -> number.doubleValue() > compareTo.doubleValue(), () -> errorDescription);
    }

    public <T extends Number> Validation<T> isBetween(T min, T max, ErrorDescription errorDescription) {
        return SimpleValidation.from(number -> Range.between((Comparable)Double.valueOf(min.doubleValue()), (Comparable)Double.valueOf(max.doubleValue())).contains((Object)number.doubleValue()), () -> errorDescription);
    }

    public <T extends Number> Validation<T> isInt(ErrorDescription errorDescription) {
        return SimpleValidation.from(t -> Range.between((Comparable)Double.valueOf(-2.147483648E9), (Comparable)Double.valueOf(2.147483647E9)).contains((Object)t.doubleValue()), () -> errorDescription);
    }

    public <T extends Number> Validation<T> isByte(ErrorDescription errorDescription) {
        return SimpleValidation.from(t -> Range.between((Comparable)Double.valueOf(-128.0), (Comparable)Double.valueOf(127.0)).contains((Object)t.doubleValue()), () -> errorDescription);
    }

    public <T extends Number> Validation<T> isShort(ErrorDescription errorDescription) {
        return SimpleValidation.from(t -> Range.between((Comparable)Double.valueOf(-32768.0), (Comparable)Double.valueOf(32767.0)).contains((Object)t.doubleValue()), () -> errorDescription);
    }
}

