/*
 * Decompiled with CFR 0.152.
 */
package at.meks.validation.validations.list;

import at.meks.validation.ErrorMessageResolver;
import at.meks.validation.Validation;
import at.meks.validation.result.ErrorDescriptionBuilder;
import at.meks.validation.validations.list.CoreListValidations;
import java.util.List;
import java.util.function.Function;

public class ListValidations {
    private static ErrorMessageResolver messageResolver = new ErrorMessageResolver();
    private static CoreListValidations validations = new CoreListValidations();

    private ListValidations() {
    }

    public static <T> Validation<List<T>> containsOnly(T containedValue) {
        return validations.containsOnly(containedValue, ErrorDescriptionBuilder.withMessage(messageResolver.getListContainsOnlyMessage(containedValue)));
    }

    public static <T> Validation<List<T>> contains(T containedValue) {
        return validations.contains(containedValue, ErrorDescriptionBuilder.withMessage(messageResolver.getListContainsMessage(containedValue)));
    }

    public static <T> Validation<List<T>> doesNotContain(T excludedValue) {
        return validations.doesNotContain(excludedValue, ErrorDescriptionBuilder.withMessage(messageResolver.getListDoesNotContainMessage(excludedValue)));
    }

    public static <T> Validation<List<T>> isNotEmpty() {
        return validations.isNotEmpty(ErrorDescriptionBuilder.withMessage(messageResolver.getListIsNotEmptyMessage()));
    }

    public static <T> Validation<List<T>> isEmpty() {
        return validations.isEmpty(ErrorDescriptionBuilder.withMessage(messageResolver.getListIsEmptyMessage()));
    }

    public static <T> Validation<List<T>> hasSize(int size) {
        return validations.hasSize(size, ErrorDescriptionBuilder.withMessage(messageResolver.getListHasSizeMessage(size)));
    }

    public static <T> Validation<List<T>> hasMinSize(int size) {
        return validations.hasMinSize(size, ErrorDescriptionBuilder.withMessage(messageResolver.getListHasMinSizeMessage(size)));
    }

    public static <T> Validation<List<T>> hasMaxSize(int size) {
        return validations.hasMaxSize(size, ErrorDescriptionBuilder.withMessage(messageResolver.getListHasMaxSizeMessage(size)));
    }

    public static <T, E> Validation<List<T>> onProperty(Function<T, E> function, Validation<List<E>> validation) {
        return validations.onProperty(function, validation);
    }

    public static <T> Validation<List<T>> forType(Class<T> listType, Validation<List<T>> validation) {
        return validations.forType(listType, validation);
    }
}

