/*
 * Decompiled with CFR 0.152.
 */
package at.meks.validation.validations.list;

import at.meks.validation.Validation;
import at.meks.validation.result.ErrorDescription;
import at.meks.validation.validations.list.ListPropertyValidationImpl;
import at.meks.validation.validations.list.SimpleListValidation;
import java.util.List;
import java.util.function.Function;

class CoreListValidations {
    CoreListValidations() {
    }

    <T> Validation<List<T>> containsOnly(T containedValue, ErrorDescription errorDescription) {
        return SimpleListValidation.forList(list -> list.stream().allMatch(t -> t.equals(containedValue)), errorDescription);
    }

    <T> Validation<List<T>> contains(T containedValue, ErrorDescription errorDescription) {
        return SimpleListValidation.forList(list -> list.stream().anyMatch(t -> t.equals(containedValue)), errorDescription);
    }

    <T> Validation<List<T>> doesNotContain(T excludedValue, ErrorDescription errorDescription) {
        return SimpleListValidation.forList(list -> list.stream().noneMatch(t -> t.equals(excludedValue)), errorDescription);
    }

    <T> Validation<List<T>> isNotEmpty(ErrorDescription errorDescription) {
        return SimpleListValidation.forList(list -> list != null && !list.isEmpty(), errorDescription);
    }

    <T> Validation<List<T>> isEmpty(ErrorDescription errorDescription) {
        return SimpleListValidation.forList(list -> list != null && list.isEmpty(), errorDescription);
    }

    <T> Validation<List<T>> hasSize(int size, ErrorDescription errorDescription) {
        return SimpleListValidation.forList(list -> list != null && list.size() == size, errorDescription);
    }

    <T> Validation<List<T>> hasMinSize(int size, ErrorDescription errorDescription) {
        return SimpleListValidation.forList(list -> list != null && list.size() >= size, errorDescription);
    }

    <T> Validation<List<T>> hasMaxSize(int size, ErrorDescription errorDescription) {
        return SimpleListValidation.forList(list -> list != null && list.size() <= size, errorDescription);
    }

    <T, E> Validation<List<T>> onProperty(Function<T, E> function, Validation<List<E>> validation) {
        return ListPropertyValidationImpl.onProperty(function, validation);
    }

    <T> Validation<List<T>> forType(Class<T> listType, Validation<List<T>> validation) {
        return validation;
    }
}

