/*
 * Decompiled with CFR 0.152.
 */
package at.makubi.maven.plugin.avrohugger;

import at.makubi.maven.plugin.avrohugger.AvrohuggerGenerator;
import at.makubi.maven.plugin.avrohugger.SourceGenerationFormat;
import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="generate-scala-sources")
public class GeneratorMojo
extends AbstractMojo {
    @Parameter(property="sourceDirectory", defaultValue="${basedir}/src/main/avro", required=true)
    private File sourceDirectory;
    @Parameter(property="outputDirectory", defaultValue="${project.build.directory}/generated-sources/avro", required=true)
    private File outputDirectory;
    @Parameter(property="recursive", defaultValue="false", required=true)
    private Boolean recursive;
    @Parameter(property="limitedNumberOfFieldsInCaseClasses", defaultValue="false", required=true)
    private Boolean limitedNumberOfFieldsInCaseClasses;
    @Parameter(property="sourceGenerationFormat", defaultValue="SPECIFIC_RECORD", required=true)
    private SourceGenerationFormat sourceGenerationFormat;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String sourceDirectoryPath = this.sourceDirectory.getAbsolutePath();
        if (!this.sourceDirectory.isDirectory()) {
            throw new MojoExecutionException(sourceDirectoryPath + " does not exist or is not a directory");
        }
        String outputDirectoryPath = this.outputDirectory.getAbsolutePath();
        this.getLog().info((CharSequence)("Generating Scala files for schemas in " + sourceDirectoryPath + " to " + outputDirectoryPath));
        AvrohuggerGenerator generator = new AvrohuggerGenerator();
        generator.generateScalaFiles(this.sourceDirectory, outputDirectoryPath, this.getLog(), this.recursive, this.limitedNumberOfFieldsInCaseClasses, this.sourceGenerationFormat);
    }
}

