/*
 * Decompiled with CFR 0.152.
 */
package at.jku.isse.gradient.gradle.tasks;

import at.jku.isse.gradient.Gradient;
import at.jku.isse.gradient.lang.java.StructuralModel;
import at.jku.isse.gradient.model.StructuralCache;
import at.jku.isse.gradient.service.CodeService;
import com.google.gson.Gson;
import com.google.inject.Injector;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001BW\b\u0007\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u0019H\u0007J\b\u0010\u001b\u001a\u00020\u001cH\u0002R\u0016\u0010\u000b\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0010R\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lat/jku/isse/gradient/gradle/tasks/CodeAnalysisTask;", "Lorg/gradle/api/DefaultTask;", "groupName", "Lorg/gradle/api/provider/Property;", "", "projectName", "gradientModelRegex", "tags", "Lorg/gradle/api/provider/ListProperty;", "inputFiles", "Lorg/gradle/api/file/FileCollection;", "classFiles", "gradientCache", "Ljava/io/File;", "(Lorg/gradle/api/provider/Property;Lorg/gradle/api/provider/Property;Lorg/gradle/api/provider/Property;Lorg/gradle/api/provider/ListProperty;Lorg/gradle/api/file/FileCollection;Lorg/gradle/api/file/FileCollection;Ljava/io/File;)V", "getClassFiles", "()Lorg/gradle/api/file/FileCollection;", "codeService", "Lat/jku/isse/gradient/service/CodeService;", "gradient", "Lat/jku/isse/gradient/Gradient;", "getGradientCache", "()Ljava/io/File;", "getInputFiles", "addDynamicTags", "", "analyze", "executeAnalysis", "Lat/jku/isse/gradient/model/StructuralCache;", "gradle-plugin"})
public class CodeAnalysisTask
extends DefaultTask {
    private final Gradient gradient;
    private final CodeService codeService;
    @Input
    private final Property<String> groupName;
    @Input
    private final Property<String> projectName;
    @Input
    private final Property<String> gradientModelRegex;
    @Input
    private final ListProperty<String> tags;
    @InputFiles
    @NotNull
    private final FileCollection inputFiles;
    @InputFiles
    @NotNull
    private final FileCollection classFiles;
    @OutputFile
    @NotNull
    private final File gradientCache;

    /*
     * WARNING - void declaration
     */
    private final StructuralCache executeAnalysis() {
        List list;
        void $this$mapTo$iv$iv;
        String string;
        Collection collection;
        void $this$mapTo$iv$iv2;
        boolean bl = !this.inputFiles.isEmpty();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            String string2 = "Expected non-empty input files.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        Iterable $this$map$iv = (Iterable)this.inputFiles;
        boolean $i$f$map = false;
        Iterable $i$a$1$require = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            File file = (File)item$iv$iv;
            collection = destination$iv$iv;
            void v0 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"it");
            string = v0.getAbsolutePath();
            collection.add(string);
        }
        List inputPaths = (List)destination$iv$iv;
        Iterable $this$map$iv2 = (Iterable)this.classFiles;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File $i$a$1$map = (File)item$iv$iv;
            collection = destination$iv$iv2;
            void v1 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
            string = v1.getAbsolutePath();
            collection.add(string);
        }
        List classPaths = (List)destination$iv$iv2;
        this.getLogger().debug("Staring the code analysis: " + inputPaths.size() + " source files");
        if (this.gradientModelRegex.isPresent()) {
            list = CollectionsKt.listOf((Object)this.gradientModelRegex.get());
        } else {
            $i$f$map2 = false;
            list = CollectionsKt.emptyList();
        }
        List additionalGradientModelRegex = list;
        Object object = this.groupName.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"groupName.get()");
        String string3 = (String)object;
        Object object2 = this.projectName.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"projectName.get()");
        String string4 = (String)object2;
        Collection collection2 = inputPaths;
        Collection collection3 = classPaths;
        Collection collection4 = additionalGradientModelRegex;
        Object object3 = this.tags.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"tags.get()");
        StructuralModel codeModel = this.codeService.analyze(string3, string4, collection2, collection3, collection4, (Collection)object3);
        StructuralCache structuralCache = this.codeService.prepareGradientCache(codeModel);
        boolean bl4 = false;
        boolean bl5 = false;
        StructuralCache it = structuralCache;
        it.setAdditionalGradientModelRegex((String)this.gradientModelRegex.getOrNull());
        return structuralCache;
    }

    private final void addDynamicTags() {
        if (this.getProject().hasProperty("gTags")) {
            Project project = this.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
            Object v = project.getProperties().get("gTags");
            if (v == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
            }
            String tagString = (String)v;
            this.getLogger().debug("Adding dynamic tags to project: " + tagString);
            Iterable $this$forEach$iv = StringsKt.split$default((CharSequence)tagString, (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                this.tags.add((Object)it);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public final void analyze() {
        this.addDynamicTags();
        StructuralCache cache = this.executeAnalysis();
        this.getLogger().debug("Writing gradient cache.");
        Closeable closeable = new FileWriter(this.gradientCache);
        boolean bl = false;
        Throwable throwable = null;
        try {
            FileWriter it = (FileWriter)closeable;
            new Gson().toJson((Object)cache, (Appendable)it);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @NotNull
    public final FileCollection getInputFiles() {
        return this.inputFiles;
    }

    @NotNull
    public final FileCollection getClassFiles() {
        return this.classFiles;
    }

    @NotNull
    public final File getGradientCache() {
        return this.gradientCache;
    }

    @Inject
    public CodeAnalysisTask(@NotNull Property<String> groupName, @NotNull Property<String> projectName, @NotNull Property<String> gradientModelRegex, @NotNull ListProperty<String> tags, @NotNull FileCollection inputFiles, @NotNull FileCollection classFiles, @NotNull File gradientCache) {
        Intrinsics.checkParameterIsNotNull(groupName, (String)"groupName");
        Intrinsics.checkParameterIsNotNull(projectName, (String)"projectName");
        Intrinsics.checkParameterIsNotNull(gradientModelRegex, (String)"gradientModelRegex");
        Intrinsics.checkParameterIsNotNull(tags, (String)"tags");
        Intrinsics.checkParameterIsNotNull((Object)inputFiles, (String)"inputFiles");
        Intrinsics.checkParameterIsNotNull((Object)classFiles, (String)"classFiles");
        Intrinsics.checkParameterIsNotNull((Object)gradientCache, (String)"gradientCache");
        this.groupName = groupName;
        this.projectName = projectName;
        this.gradientModelRegex = gradientModelRegex;
        this.tags = tags;
        this.inputFiles = inputFiles;
        this.classFiles = classFiles;
        this.gradientCache = gradientCache;
        this.gradient = new Gradient();
        this.setGroup("analysis");
        this.setDescription("Executes the Gradient code analysis and sets the information to the Gradient Server");
        this.getLogger().debug("Bootstrapping gradient client.");
        Injector injector = this.gradient.bootstrapGradient();
        Object object = injector.getInstance(CodeService.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"injector.getInstance(CodeService::class.java)");
        this.codeService = (CodeService)object;
        this.setOnlyIf((Spec)new Spec<Task>(){

            public final boolean isSatisfiedBy(Task it) {
                return gradient.gradientBackendAvailable();
            }
        });
    }
}

