package at.jku.isse.gradient.gradle

import org.gradle.api.Project
import org.gradle.api.provider.Property

open class GradientExtension(project: Project) {
    var groupName: Property<String> = project.objects.property(String::class.java)
    var projectName: Property<String> = project.objects.property(String::class.java)

    /**
     * Provide the type pattern to include into gradient:
     *
     *     * TypeNamePattern	all types in TypeNamePattern
     *     * SubtypePattern	all types in SubtypePattern, a pattern with a +.
     *     * ArrayTypePattern	all types in ArrayTypePattern, a pattern with one or more []s.
     *     * !TypePattern	all types not in TypePattern
     *     * TypePattern0 && TypePattern1	all types in both TypePattern0 and TypePattern1
     *     * TypePattern0 || TypePattern1	all types in either TypePattern0 or TypePattern1
     *     * ( TypePattern )	all types in TypePattern
     *
     * where TypeNamePattern can either be a plain type name, the wildcard * (indicating all types), or an identifier with embedded * and .. wildcards.
     *
     * An embedded * in an identifier matches any sequence of characters, but does not match the package (or inner-type) separator ".".
     * An embedded .. in an identifier matches any sequence of characters that starts and ends with the package (or inner-type) separator ".".
     *
     */
    var includes: Property<String> = project.objects.property(String::class.java)

    init {
        groupName.set(project.group as String)
        projectName.set(project.name as String)
    }
}