/*
 * Decompiled with CFR 0.152.
 */
package at.jku.isse.gradient.gradle.tasks;

import at.jku.isse.gradient.Gradient;
import at.jku.isse.gradient.lang.java.StructuralModel;
import at.jku.isse.gradient.model.StructuralCache;
import at.jku.isse.gradient.service.StructuralService;
import com.google.gson.Gson;
import com.google.inject.Injector;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Property;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001BI\b\u0007\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0016\u001a\u00020\u0017H\u0007J\b\u0010\u0018\u001a\u00020\u0019H\u0002R\u0016\u0010\t\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lat/jku/isse/gradient/gradle/tasks/StructuralAnalysisTask;", "Lorg/gradle/api/DefaultTask;", "groupName", "Lorg/gradle/api/provider/Property;", "", "projectName", "gradientModelRegex", "inputFiles", "Lorg/gradle/api/file/FileCollection;", "classFiles", "structuralCacheFile", "Ljava/io/File;", "(Lorg/gradle/api/provider/Property;Lorg/gradle/api/provider/Property;Lorg/gradle/api/provider/Property;Lorg/gradle/api/file/FileCollection;Lorg/gradle/api/file/FileCollection;Ljava/io/File;)V", "getClassFiles", "()Lorg/gradle/api/file/FileCollection;", "gradient", "Lat/jku/isse/gradient/Gradient;", "getInputFiles", "getStructuralCacheFile", "()Ljava/io/File;", "structuralService", "Lat/jku/isse/gradient/service/StructuralService;", "analyze", "", "executeAnalysis", "Lat/jku/isse/gradient/model/StructuralCache;", "gradle-plugin"})
public class StructuralAnalysisTask
extends DefaultTask {
    private final Gradient gradient;
    private final StructuralService structuralService;
    @Input
    private final Property<String> groupName;
    @Input
    private final Property<String> projectName;
    @Input
    private final Property<String> gradientModelRegex;
    @InputFiles
    @NotNull
    private final FileCollection inputFiles;
    @InputFiles
    @NotNull
    private final FileCollection classFiles;
    @OutputFile
    @NotNull
    private final File structuralCacheFile;

    /*
     * WARNING - void declaration
     */
    private final StructuralCache executeAnalysis() {
        void $receiver$iv$iv;
        String string;
        Collection collection;
        void $receiver$iv$iv2;
        Iterable $receiver$iv;
        boolean bl;
        boolean bl2 = bl = !this.inputFiles.isEmpty();
        if (!bl) {
            String string2 = "Expected non-empty input files.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        Iterable iterable = $receiver$iv = (Iterable)this.inputFiles;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        StructuralCache structuralCache = $receiver$iv$iv2.iterator();
        while (structuralCache.hasNext()) {
            void it;
            Object item$iv$iv = structuralCache.next();
            File file = (File)item$iv$iv;
            collection = destination$iv$iv;
            void v1 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
            string = v1.getAbsolutePath();
            collection.add(string);
        }
        List inputPaths = (List)destination$iv$iv;
        Iterable $receiver$iv2 = (Iterable)this.classFiles;
        destination$iv$iv = $receiver$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            File $i$a$1$map = (File)item$iv$iv;
            collection = destination$iv$iv2;
            void v2 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"it");
            string = v2.getAbsolutePath();
            collection.add(string);
        }
        List classPaths = (List)destination$iv$iv2;
        this.getLogger().debug("Staring the structural analysis: " + inputPaths.size() + " source files");
        List additionalGradientModelRegex = this.gradientModelRegex.isPresent() ? CollectionsKt.listOf((Object)this.gradientModelRegex.get()) : CollectionsKt.emptyList();
        Object object = this.groupName.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"groupName.get()");
        String string3 = (String)object;
        Object object2 = this.projectName.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"projectName.get()");
        StructuralModel structuralModel = this.structuralService.analyze(string3, (String)object2, (Collection)inputPaths, (Collection)classPaths, (Collection)additionalGradientModelRegex);
        StructuralCache it = structuralCache = this.structuralService.prepareStructuralCache(structuralModel);
        it.setAdditionalGradientModelRegex((String)this.gradientModelRegex.getOrNull());
        return structuralCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public final void analyze() {
        StructuralCache structuralCache = this.executeAnalysis();
        this.getLogger().debug("Writing structural cache.");
        Closeable closeable = new FileWriter(this.structuralCacheFile);
        Throwable throwable = null;
        try {
            FileWriter it = (FileWriter)closeable;
            new Gson().toJson((Object)structuralCache, (Appendable)it);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @NotNull
    public final FileCollection getInputFiles() {
        return this.inputFiles;
    }

    @NotNull
    public final FileCollection getClassFiles() {
        return this.classFiles;
    }

    @NotNull
    public final File getStructuralCacheFile() {
        return this.structuralCacheFile;
    }

    @Inject
    public StructuralAnalysisTask(@NotNull Property<String> groupName, @NotNull Property<String> projectName, @NotNull Property<String> gradientModelRegex, @NotNull FileCollection inputFiles, @NotNull FileCollection classFiles, @NotNull File structuralCacheFile) {
        Intrinsics.checkParameterIsNotNull(groupName, (String)"groupName");
        Intrinsics.checkParameterIsNotNull(projectName, (String)"projectName");
        Intrinsics.checkParameterIsNotNull(gradientModelRegex, (String)"gradientModelRegex");
        Intrinsics.checkParameterIsNotNull((Object)inputFiles, (String)"inputFiles");
        Intrinsics.checkParameterIsNotNull((Object)classFiles, (String)"classFiles");
        Intrinsics.checkParameterIsNotNull((Object)structuralCacheFile, (String)"structuralCacheFile");
        this.groupName = groupName;
        this.projectName = projectName;
        this.gradientModelRegex = gradientModelRegex;
        this.inputFiles = inputFiles;
        this.classFiles = classFiles;
        this.structuralCacheFile = structuralCacheFile;
        this.gradient = new Gradient();
        this.setGroup("analysis");
        this.setDescription("Executes the Gradient structural analysis and sets the information to the Gradient Server");
        this.getLogger().debug("Bootstrapping gradient client.");
        Injector injector = this.gradient.bootstrapGradient();
        Object object = injector.getInstance(StructuralService.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"injector.getInstance(Str\u2026turalService::class.java)");
        this.structuralService = (StructuralService)object;
        this.setOnlyIf((Spec)new Spec<Task>(){

            public final boolean isSatisfiedBy(Task it) {
                return gradient.gradientBackendAvailable();
            }
        });
    }
}

