package at.jku.isse.gradient.gradle.tasks

import at.jku.isse.gradient.Gradient
import at.jku.isse.gradient.service.StructuralService
import org.gradle.api.DefaultTask
import org.gradle.api.file.FileCollection
import org.gradle.api.provider.Property
import org.gradle.api.tasks.Input
import org.gradle.api.tasks.InputFiles
import org.gradle.api.tasks.TaskAction
import javax.inject.Inject


open class StructuralAnalysisTask
@Inject constructor(@Input private val groupName: Property<String>,
                    @Input private val projectName: Property<String>,
                    @InputFiles private val inputFiles: FileCollection) : DefaultTask() {

    private val gradientClient = Gradient()

    private val structuralService: StructuralService by lazy {
        logger.debug("Bootstrapping gradient client.")
        gradientClient.bootstrapGradient().getInstance(StructuralService::class.java)
    }

    init {
        group = "analysis"
        description = "Executes the Gradient structural analysis and sets the information to the Gradient Server"

        setOnlyIf {
            gradientClient.gradientBackendAvailable()
        }
    }

    @TaskAction
    fun analyze() {
        require(!inputFiles.isEmpty) { "Expected non-empty input files." }

        val inputPaths = inputFiles.map { it.absolutePath }
        structuralService.analyze(groupName.get(), projectName.get(), inputPaths)
    }
}