package at.jku.isse.gradient.gradle.tasks

import at.jku.isse.gradient.monitoring.__Gradient_Observable_Impl__
import at.jku.isse.gradient.monitoring.__Gradient_Observable__
import com.squareup.javapoet.AnnotationSpec
import com.squareup.javapoet.FieldSpec
import com.squareup.javapoet.JavaFile
import com.squareup.javapoet.TypeSpec
import org.aspectj.lang.annotation.Aspect
import org.aspectj.lang.annotation.DeclareParents
import org.gradle.api.DefaultTask
import org.gradle.api.file.Directory
import org.gradle.api.provider.Provider
import org.gradle.api.tasks.Input
import org.gradle.api.tasks.OutputDirectory
import org.gradle.api.tasks.TaskAction
import javax.inject.Inject
import javax.lang.model.element.Modifier

open class GenerateAdditionalPointcutsTask
@Inject constructor(@OutputDirectory val outputDirectory: Directory,
                    @Input val typePattern: Provider<String>) : DefaultTask() {

    init {
        description = "Generates additional aspects including pointcut handling the extension <includes> and <excludes>."
        onlyIf {
            typePattern.isPresent
        }
    }

    private fun configureAspectSpec(typePattern: String): TypeSpec {
        require(typePattern.isNotBlank()) { "Expected to find type patterns." }

        val implementInterfacesSpec = FieldSpec.builder(__Gradient_Observable__::class.java,
                "implementedInterfaces")
                .addModifiers(Modifier.PRIVATE)
                .addAnnotation(
                        AnnotationSpec.builder(DeclareParents::class.java)
                                .addMember("value", "\$S", typePattern)
                                .addMember("defaultImpl", "\$T.class", __Gradient_Observable_Impl__::class.java)
                                .build()
                )
                .build()
        return TypeSpec.classBuilder("DynamicObservableWeaver")
                .addModifiers(Modifier.PUBLIC)
                .addAnnotation(Aspect::class.java)
                .addField(implementInterfacesSpec)
                .build()
    }

    @TaskAction
    fun generate() {
        if (typePattern.get().isNotBlank()) {
            logger.debug("Generating additional aspects.")
            val typeSpec = configureAspectSpec(typePattern.get())

            val javaFile = JavaFile.builder("at.jku.isse.gradient.monitoring", typeSpec).build()

            javaFile.writeTo(outputDirectory.asFile)
        }
    }
}
