package at.jku.isse.gradient.gradle

import com.google.common.io.Resources
import java.util.*

object Conventions {
    const val CONFIGURATION_ASPECTJ = "aspectj"
    const val CONFIGURATION_GRADIENT = "monitoring"
    const val CONFIGURATION_COMPILE_CLASSPATH = "compileClasspath"
    const val CONFIGURATION_RUNTIME_CLASSPATH = "runtime"
    const val TASK_COMPILE_JAVA = "compileJava"
    const val TASK_COMPILE_ASPECTJ = "compileAspectj"
    const val TASK_GENERATE_ADDITIONAL_POINTCUTS = "generateAdditionalPointcuts"
    const val TASK_STRUCTURAL_ANALYSIS = "structuralAnalysis"
    const val JAVA_SOURCE_COMPATIBILITY = "1.8"
    const val JAVA_TARGET_COMPATIBILITY = "1.8"
    const val FILE_ADDITIONAL_POINTCUTS = "build/genSrc/java/main/"

    private const val PROPERTIES_FILE = "gradient-gradle.properties"
    private val dynamicConventions by lazy {
        val url = Resources.getResource(PROPERTIES_FILE)
        Properties().also {
            url.openStream().use { stream -> it.load(stream) }
        }
    }

    val dependencyAspectjRt: String by dynamicConventions
    val dependencyAspectjTools: String by dynamicConventions
    val dependencyGradientAspects: String by dynamicConventions
}


