package at.jku.isse.gradient.gradle

import org.apache.tools.ant.BuildException
import org.apache.tools.ant.types.Path
import org.aspectj.tools.ant.taskdefs.AjcTask
import org.gradle.api.DefaultTask
import org.gradle.api.file.ConfigurableFileCollection
import org.gradle.api.tasks.InputFiles
import org.gradle.api.tasks.OutputDirectories
import org.gradle.api.tasks.TaskAction
import java.io.File


open class CompileAspectj : DefaultTask() {

    companion object {
        private val exists = { it: File -> it.exists() }
    }

    /**
     * Directories containing source files (ending with .java or .aj) to compile.
     */
    @InputFiles
    var sourceRoots: ConfigurableFileCollection = project.files()

    /**
     * Read .class files for bytecode weaving from directories or zip files (like classpath).
     */
    @InputFiles
    var inputPaths: ConfigurableFileCollection = project.files()

    /**
     * Similar to classpath, aspectpath contains read-only, binary aspect libraries that are woven into sources but not included in the output. aspectpath accepts jar/zip files (but, unlike classpath, not directories).
     */
    @InputFiles
    var aspectPaths: ConfigurableFileCollection = project.files()

    /**
     * The classpath used by the sources being compiled. When compiling aspects, include the same version of the aspectjrt.jar.
     */
    @InputFiles
    var classPaths: ConfigurableFileCollection = project.files()

    /**
     * The directory in which to place the generated class files. Only one of destDir and outJar may be set
     */
    @OutputDirectories
    var destinationDirectories: ConfigurableFileCollection = project.files()


    init {
        description = "Weaves the aspects into the Bytecode using the Aspectj compiler."
    }

    @TaskAction
    fun compile() {
        logger.info("Compiling with ajc.")
        logger.debug("Configuring aspectj ant task.")

        with(AjcTask()) {
            sourceRoots
                    .filter(exists)
                    .forEach { setSourceRoots(Path(project, it.path)) }
            inputPaths
                    .filter(exists)
                    .forEach { setInpath(Path(project, it.path)) }
            aspectPaths
                    .filter(exists)
                    .forEach { setAspectpath(Path(project, it.path)) }
            classPaths
                    .filter(exists)
                    .forEach { setClasspath(Path(project, it.path)) }
            destinationDirectories
                    .forEach { setDestdir(it) }

            try {
                logger.debug("Starting compiliation")

                execute()

                logger.debug("Finished compiliation")
            } catch (ex: BuildException) {
                logger.error("Compiling the sources with the aspectj compiler failed.", ex)
            }
        }
    }
}
