package at.jku.isse.gradient.gradle

import at.jku.isse.gradient.injector
import at.jku.isse.gradient.service.StructuralService
import org.gradle.api.DefaultTask
import org.gradle.api.file.FileCollection
import org.gradle.api.provider.Property
import org.gradle.api.tasks.Input
import org.gradle.api.tasks.InputFiles
import org.gradle.api.tasks.TaskAction

open class StructuralAnalysis @javax.inject.Inject constructor(@Input val groupName: Property<String>,
                                                               @Input val projectName: Property<String>,
                                                               @InputFiles val inputFiles: FileCollection) : DefaultTask() {

    private val structuralService: StructuralService? by lazy {
        setupGradient()
    }

    init {
        group = "analysis"
        description = "Executes the Gradient structural analysis and sets the information to the Gradient Server"

        setOnlyIf {
            structuralService != null
        }
    }


    private fun setupGradient(): StructuralService? {
        logger.debug("Bootstrapping gradient client.")
        return try {
            injector.getInstance(StructuralService::class.java)
        } catch (e: Exception) {
            logger.info("Structural Analysis will be skipped as not backend service is available.")
            logger.debug("Error during bootstrapping the gradient client library", e)
            null
        }
    }


    @TaskAction
    fun analyze() {
        require(!inputFiles.isEmpty) { "Expected non-empty input files." }

        structuralService?.let {
            val inputPaths = inputFiles.map { it.absolutePath }
            it.analyze(groupName.get(), projectName.get(), inputPaths)
        }
    }
}