/*
 * Decompiled with CFR 0.152.
 */
package at.jku.isse.psma.gradient.gradle;

import at.jku.isse.psma.gradient.GradientContextKt;
import at.jku.isse.psma.gradient.service.StructuralService;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.gradle.tooling.BuildException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B+\b\u0007\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0010\u001a\u00020\u0011H\u0007J\b\u0010\u0012\u001a\u00020\u0011H\u0002R\u001c\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0012\u0010\u000e\u001a\u00020\u000f8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lat/jku/isse/psma/gradient/gradle/StructuralAnalysis;", "Lorg/gradle/api/DefaultTask;", "groupName", "Lorg/gradle/api/provider/Property;", "", "projectName", "inputFiles", "Lorg/gradle/api/file/FileCollection;", "(Lorg/gradle/api/provider/Property;Lorg/gradle/api/provider/Property;Lorg/gradle/api/file/FileCollection;)V", "getGroupName", "()Lorg/gradle/api/provider/Property;", "getInputFiles", "()Lorg/gradle/api/file/FileCollection;", "getProjectName", "structuralService", "Lat/jku/isse/psma/gradient/service/StructuralService;", "analyze", "", "setupGradient", "gradle-plugin"})
public class StructuralAnalysis
extends DefaultTask {
    @Inject
    @Internal
    private StructuralService structuralService;
    @Input
    @NotNull
    private final Property<String> groupName;
    @Input
    @NotNull
    private final Property<String> projectName;
    @InputFiles
    @NotNull
    private final FileCollection inputFiles;

    private final void setupGradient() {
        this.getLogger().debug("Bootstrapping gradient client.");
        try {
            Injector injector = GradientContextKt.bootstrapGradient();
            injector.injectMembers((Object)this);
        }
        catch (Exception e) {
            throw (Throwable)new BuildException("Error during bootstrapping the gradient client library", (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @TaskAction
    public final void analyze() {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        boolean bl;
        this.setupGradient();
        boolean bl2 = bl = !this.inputFiles.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Expected non-empty input files.";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Iterable iterable = $receiver$iv = (Iterable)this.inputFiles;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            void v1 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
            String string = v1.getAbsolutePath();
            collection.add(string);
        }
        List inputPaths = (List)destination$iv$iv;
        StructuralService structuralService = this.structuralService;
        if (structuralService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"structuralService");
        }
        Object object = this.groupName.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"groupName.get()");
        String string = (String)object;
        Object object2 = this.projectName.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"projectName.get()");
        structuralService.analyze(string, (String)object2, (Iterable)inputPaths);
    }

    @NotNull
    public final Property<String> getGroupName() {
        return this.groupName;
    }

    @NotNull
    public final Property<String> getProjectName() {
        return this.projectName;
    }

    @NotNull
    public final FileCollection getInputFiles() {
        return this.inputFiles;
    }

    @javax.inject.Inject
    public StructuralAnalysis(@NotNull Property<String> groupName, @NotNull Property<String> projectName, @NotNull FileCollection inputFiles) {
        Intrinsics.checkParameterIsNotNull(groupName, (String)"groupName");
        Intrinsics.checkParameterIsNotNull(projectName, (String)"projectName");
        Intrinsics.checkParameterIsNotNull((Object)inputFiles, (String)"inputFiles");
        this.groupName = groupName;
        this.projectName = projectName;
        this.inputFiles = inputFiles;
        this.setGroup("analysis");
        this.setDescription("Executes the Gradient structural analysis and sets the information to the Gradient Server");
    }
}

