package at.jku.isse.psma.gradient.gradle

import at.jku.isse.psma.gradient.bootstrapGradient
import at.jku.isse.psma.gradient.service.StructuralService
import com.google.inject.Inject
import org.gradle.api.DefaultTask
import org.gradle.api.file.FileCollection
import org.gradle.api.provider.Property
import org.gradle.api.tasks.Input
import org.gradle.api.tasks.InputFiles
import org.gradle.api.tasks.Internal
import org.gradle.api.tasks.TaskAction
import org.gradle.tooling.BuildException

open class StructuralAnalysis @javax.inject.Inject constructor(@Input val groupName: Property<String>,
                                                               @Input val projectName: Property<String>,
                                                               @InputFiles val inputFiles: FileCollection) : DefaultTask() {
    @Inject
    @Internal
    private lateinit var structuralService: StructuralService

    init {
        group = "analysis"
        description = "Executes the Gradient structural analysis and sets the information to the Gradient Server"
    }

    private fun setupGradient() {
        logger.debug("Bootstrapping gradient client.")
        try {
            val injector = bootstrapGradient()
            injector.injectMembers(this)
        } catch (e: Exception) {
            throw BuildException("Error during bootstrapping the gradient client library", e)
        }
    }

    @TaskAction
    fun analyze() {
        setupGradient()

        assert(!inputFiles.isEmpty) { "Expected non-empty input files." }

        val inputPaths = inputFiles.map { it.absolutePath }
        structuralService.analyze(groupName.get(), projectName.get(), inputPaths)
    }
}