package at.jku.isse.gradient.service

import at.jku.isse.gradient.lang.java.StructuralModel
import at.jku.isse.gradient.model.StructuralCache
import java.util.*

interface CodeService {
    fun analyze(groupName: String,
                projectName: String,
                sourcePaths: Collection<String>,
                classPaths: Collection<String> = listOf(),
                gradientModelRegex: Collection<String> = listOf(),
                tags: Collection<String> = listOf()): StructuralModel

    fun prepareGradientCache(structuralModel: StructuralModel): StructuralCache
}


interface EventService {
    fun reportPropertyRead(elementName: String, objectId: UUID, obj: Any?)

    fun reportPropertyWrite(elementName: String, objectId: UUID, obj: Any?)

    fun reportExecutableCall(elementName: String, objectId: UUID)

    fun reportExecutableParameter(elementName: String, objectId: UUID, obj: Any?)

    fun reportExecutableReturn(elementName: String, objectId: UUID, obj: Any?)

    fun reportExecutableException(elementName: String, objectId: UUID, exception: Throwable)
}

