package at.jku.isse.gradient.model

import java.time.Instant
import java.util.*

class Version : CanonicalEntity {

    var versionHash: ByteArray = ByteArray(0)
    var revisions: MutableSet<Versionable> = mutableSetOf()
    var timestamp = Instant.now().epochSecond

    constructor()
    constructor(id: UUID,
                versionHash: ByteArray,
                revisions: MutableSet<Versionable>) : super(id, "", "") {
        this.revisions = revisions
        this.versionHash = versionHash
    }

    override fun accept(visitor: ModelVisitor) = visitor.visitVersion(this)

    override fun toString(): String {
        return "Version(id='$id')"
    }
}