package at.jku.isse.gradient.model

import com.google.common.hash.HashCode
import java.util.*

class Type : CanonicalEntity, Versionable {
    var availability: Availability = Availability.UNAVAILABLE

    var quality: Quality = Quality.PURE
    var visibility: Visibility = Visibility.PUBLIC
    var isGenerics: Boolean = false
    var isModel: Boolean = false
    override var versionHash: HashCode = HashCode.fromInt(0)

    var typeParameters: MutableSet<Type> = mutableSetOf()
    var isExtending: MutableSet<Type> = mutableSetOf()
    var properties: MutableSet<Property> = mutableSetOf()
    var executables: MutableSet<Executable> = mutableSetOf()
    var inheritedProperties: MutableSet<Property> = mutableSetOf()
    var inheritedExecutables: MutableSet<Executable> = mutableSetOf()


    constructor()
    constructor(id: UUID,
                name: String,
                canonicalName: String,
                availability: Availability,
                quality: Quality,
                visibility: Visibility,
                isGenerics: Boolean,
                isGradientModel: Boolean,
                versionHash: HashCode) : super(id, name, canonicalName) {
        this.availability = availability
        this.quality = quality
        this.visibility = visibility
        this.isGenerics = isGenerics
        this.versionHash = versionHash
        this.isModel = isGradientModel
    }

    override fun toString(): String {
        return "Type(id='$canonicalName')"
    }

    override fun accept(visitor: ModelVisitor) = visitor.visitType(this)
}