package at.jku.isse.gradient.model

import java.util.*

class Project : CanonicalEntity {

    lateinit var version: Version
    var tags: MutableList<String> = mutableListOf()

    constructor()
    constructor(id: UUID,
                name: String,
                canonicalName: String,
                version: Version,
                tags: Collection<String> = listOf()) : super(id, name, canonicalName) {
        this.version = version
        this.tags.addAll(tags)
    }

    override fun toString(): String {
        return "Project(id='$canonicalName')"
    }

    override fun accept(visitor: ModelVisitor) = visitor.visitProject(this)
}