package at.jku.isse.gradient.model

import com.google.common.hash.HashCode
import java.util.*

class Executable : TypedElement, Versionable {

    var isAbstract: Boolean = false
    var visibility: Visibility = Visibility.PUBLIC
    var isStatic: Boolean = false
    var isConstructor: Boolean = false
    var accessor: Accessor = Accessor.NONE
    override var versionHash: HashCode = HashCode.fromInt(0)

    var overrides: MutableSet<Overriding> = mutableSetOf()
    var parameters: MutableSet<Parameter> = mutableSetOf()
    var returns: MutableSet<ElementType> = mutableSetOf()
    var accesses: MutableSet<Access> = mutableSetOf()
    var invokes: MutableSet<Invocation> = mutableSetOf()
    var typeParameters: MutableSet<Type> = mutableSetOf()

    constructor()
    constructor(id: UUID,
                name: String,
                canonicalName: String,
                isAbstract: Boolean,
                visibility: Visibility,
                isStatic: Boolean,
                isConstructor: Boolean,
                dataType: DataType,
                versionHash: HashCode) : super(id, name, canonicalName, dataType) {
        this.isAbstract = isAbstract
        this.visibility = visibility
        this.isStatic = isStatic
        this.isConstructor = isConstructor
        this.versionHash = versionHash
    }

    constructor(id: UUID,
                name: String,
                canonicalName: String,
                isConstructor: Boolean,
                dataType: DataType,
                versionHash: HashCode) : super(id, name, canonicalName, dataType) {
        this.isConstructor = isConstructor
        this.versionHash = versionHash
    }

    override fun toString(): String {
        return "Executable(id='$canonicalName')"
    }

    override fun accept(visitor: ModelVisitor) = visitor.visitExecutable(this)
}