package at.jku.isse.gradient.model

import java.util.*

abstract class BaseEntity : Entity {

    final override lateinit var id: UUID

    constructor()
    constructor(id: UUID) {
        this.id = id
    }

    override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if (other !is BaseEntity) return false

        if (id != other.id) return false

        return true
    }

    override fun hashCode(): Int {
        return id.hashCode()
    }
}