package at.jku.isse.gradient.dal

import at.jku.isse.gradient.GradientConfig
import at.jku.isse.gradient.dal.grpc.GrpcProjectDao
import at.jku.isse.gradient.dal.grpc.GrpcSerde
import com.google.inject.AbstractModule
import com.google.inject.Scopes
import com.google.inject.name.Names
import org.aeonbits.owner.ConfigFactory
import java.util.*


class DalModule : AbstractModule() {
    override fun configure() {
        bindConfigurations()

        bindDatabases()

        bindDaos()

        bindMappers()
    }

    private fun bindMappers() {
        bind(GrpcSerde::class.java)
    }

    private fun bindDatabases() {
        bind(UUID::class.java)
                .annotatedWith(Names.named("runtimeId"))
                .toInstance(UUID.randomUUID())

        bind(ServerManager::class.java).`in`(Scopes.SINGLETON)
    }

    private fun bindConfigurations() {
        val coreConfig = ConfigFactory.create(GradientConfig::class.java)
        bind(GradientConfig::class.java)
                .toInstance(coreConfig)
    }

    private fun bindDaos() {
        bind(ProjectDao::class.java).to(GrpcProjectDao::class.java)
    }
}