package at.jku.isse.gradient

import com.google.common.eventbus.EventBus
import com.google.inject.AbstractModule
import com.google.inject.Provides
import com.google.inject.Singleton
import mu.KotlinLogging
import org.aeonbits.owner.ConfigFactory

private val logger = KotlinLogging.logger { }

class GradientModule : AbstractModule() {

    override fun configure() {
        val config = ConfigFactory.create(GradientConfig::class.java)
        bind(GradientConfig::class.java).toInstance(config)
    }

    @Provides
    @Singleton
    fun provideEventBus(): EventBus {
        return EventBus("gradient-events").also {
            Runtime.getRuntime().addShutdownHook(Thread(Runnable {
                logger.debug { "Initiating shutdown of server" }

                it.post(GradientEvents.Cleanup)
                logger.debug { "Cleanup resources" }

                Thread.sleep(3000)

                it.post(GradientEvents.Shutdown)
                logger.debug { "Shutdown resources" }
                logger.debug { "Goodbye" }
            }))
        }
    }
}