package at.jku.isse.gradient.service

import at.jku.isse.gradient.model.StructuralCache
import at.jku.isse.gradient.service.grpc.GrpcEventService
import com.google.common.io.Resources
import com.google.gson.Gson
import com.google.inject.AbstractModule
import com.google.inject.Provides
import com.google.inject.Singleton
import mu.KotlinLogging
import java.io.InputStreamReader
import at.jku.isse.gradient.service.spoon.SpoonCodeService as SpoonStructuralService

private val logger = KotlinLogging.logger {}


private const val CODE_CACHE_FILE = "gcache.json"

class ServiceModule : AbstractModule() {

    override fun configure() {
        bind(CodeService::class.java).to(SpoonStructuralService::class.java)
        bind(EventService::class.java).to(GrpcEventService::class.java)
    }

    @Provides
    @Singleton
    fun provideStructuralCache(): StructuralCache? {
        return try {
            val url = Resources.getResource(CODE_CACHE_FILE)
            var cache: StructuralCache? = null
            InputStreamReader(Resources.asByteSource(url).openBufferedStream()).use {
                cache = Gson().fromJson<StructuralCache>(it, StructuralCache::class.java)
            }
            cache
        } catch (ex: IllegalArgumentException) {
            logger.error { "Could not find $CODE_CACHE_FILE in the resources." }
            null
        }
    }
}