package at.jku.isse.gradient.model

import java.util.*

class Parameter : TypedElement {
    companion object {
        fun canonicalNameOf(executable: Executable, index: Int): String = "${executable.canonicalName}#$index"
    }

    constructor()
    constructor(id: UUID,
                name: String,
                canonicalName: String,
                gradientType: GradientType) : super(id, name, canonicalName, gradientType) {
        require(gradientType != GradientType.VOID)
    }

    override fun toString(): String = "Parameter(id='$canonicalName')"

    override fun accept(visitor: ModelVisitor) = visitor.visitParameter(this)
}