package at.jku.isse.gradient.model

interface ModelVisitor {

    fun scan(entities: Iterable<ModelVisitable>) {
        entities.forEach { scan(it) }
    }

    fun scan(entity: ModelVisitable) {
        entity.accept(this)
    }

    fun visitAccess(e: Access) {}

    fun visitElementType(e: ElementType) {}

    fun visitType(e: Type) {}

    fun visitProperty(e: Property) {}

    fun visitExecutable(e: Executable) {}

    fun visitInvocation(e: Invocation) {}

    fun visitParameter(e: Parameter) {}

    fun visitProject(e: Project) {}

    fun visitTypeParameterMapping(e: TypeParameterMapping) {}

    fun visitVersion(e: Version) {}

    fun visitOverriding(e: Overriding) {}

    fun visitVersionable(e: Versionable) {}
}