package at.jku.isse.gradient.dal.mongo

import at.jku.isse.gradient.MongoDBConventions
import at.jku.isse.gradient.ProfilerState
import at.jku.isse.gradient.dal.EventDao
import at.jku.isse.gradient.dal.ServerManager
import at.jku.isse.gradient.dal.toMongoCollectionName
import at.jku.isse.gradient.profiledDebug
import at.jku.isse.gradient.profiledTrace
import com.google.inject.Inject
import mu.KotlinLogging
import org.bson.Document
import java.util.*

private val logger = KotlinLogging.logger {}

class MongoEventDao
@Inject constructor(private val serverManager: ServerManager) : EventDao {

    override fun reportEvents(projectName: String, versionId: UUID, observationBatch: List<Map<String, Any>>) {
        require(projectName.isNotBlank())
        require(observationBatch.isNotEmpty())

        logger.profiledTrace { "Storing ${observationBatch.size} observations: $projectName" }

        serverManager.mongoDatabase(projectName)?.let { db ->

            val collectionName = toMongoCollectionName(versionId.toString(), MongoDBConventions.EVENT_COLLECTION_POSTFIX)
            if (collectionName in db.listCollectionNames()) {
                val documents = observationBatch.map { Document(it) }
                db.getCollection(collectionName).insertMany(documents)
            } else {
                logger.error { "The event collection could not be found: $projectName@$collectionName" }
            }
        }

        logger.profiledDebug(ProfilerState.STOP) { "Finished storing ${observationBatch.size} observations: $projectName" }
    }
}