package at.jku.isse.gradient

import com.google.common.eventbus.EventBus
import com.google.inject.AbstractModule
import com.google.inject.Provides
import com.google.inject.Singleton
import org.aeonbits.owner.ConfigFactory

class GradientModule : AbstractModule() {

    override fun configure() {
        val config = ConfigFactory.create(GradientConfig::class.java)
        bind(GradientConfig::class.java).toInstance(config)
    }

    @Provides
    @Singleton
    fun provideEventBus(): EventBus {
        return EventBus("gradient-events").also {
            Runtime.getRuntime().addShutdownHook(Thread(Runnable {
                it.post(GradientEvents.Cleanup)
                it.post(GradientEvents.Shutdown)
            }))
        }
    }
}